/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.verifiedpermissions;

import javax.annotation.Generated;

import com.amazonaws.services.verifiedpermissions.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonVerifiedPermissions}. Convenient method forms pass through to the
 * corresponding overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonVerifiedPermissions implements AmazonVerifiedPermissions {

    protected AbstractAmazonVerifiedPermissions() {
    }

    @Override
    public CreateIdentitySourceResult createIdentitySource(CreateIdentitySourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePolicyResult createPolicy(CreatePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePolicyStoreResult createPolicyStore(CreatePolicyStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePolicyTemplateResult createPolicyTemplate(CreatePolicyTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIdentitySourceResult deleteIdentitySource(DeleteIdentitySourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePolicyResult deletePolicy(DeletePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePolicyStoreResult deletePolicyStore(DeletePolicyStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePolicyTemplateResult deletePolicyTemplate(DeletePolicyTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIdentitySourceResult getIdentitySource(GetIdentitySourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPolicyResult getPolicy(GetPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPolicyStoreResult getPolicyStore(GetPolicyStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPolicyTemplateResult getPolicyTemplate(GetPolicyTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSchemaResult getSchema(GetSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public IsAuthorizedResult isAuthorized(IsAuthorizedRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public IsAuthorizedWithTokenResult isAuthorizedWithToken(IsAuthorizedWithTokenRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIdentitySourcesResult listIdentitySources(ListIdentitySourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPoliciesResult listPolicies(ListPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPolicyStoresResult listPolicyStores(ListPolicyStoresRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPolicyTemplatesResult listPolicyTemplates(ListPolicyTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutSchemaResult putSchema(PutSchemaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIdentitySourceResult updateIdentitySource(UpdateIdentitySourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePolicyResult updatePolicy(UpdatePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePolicyStoreResult updatePolicyStore(UpdatePolicyStoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePolicyTemplateResult updatePolicyTemplate(UpdatePolicyTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
