/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.verifiedpermissions.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/verifiedpermissions-2021-12-01/UpdatePolicy" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdatePolicyResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The ID of the policy store that contains the policy that was updated.
     * </p>
     */
    private String policyStoreId;
    /**
     * <p>
     * The ID of the policy that was updated.
     * </p>
     */
    private String policyId;
    /**
     * <p>
     * The type of the policy that was updated.
     * </p>
     */
    private String policyType;
    /**
     * <p>
     * The principal specified in the policy's scope. This element isn't included in the response when
     * <code>Principal</code> isn't present in the policy content.
     * </p>
     */
    private EntityIdentifier principal;
    /**
     * <p>
     * The resource specified in the policy's scope. This element isn't included in the response when
     * <code>Resource</code> isn't present in the policy content.
     * </p>
     */
    private EntityIdentifier resource;
    /**
     * <p>
     * The date and time that the policy was originally created.
     * </p>
     */
    private java.util.Date createdDate;
    /**
     * <p>
     * The date and time that the policy was most recently updated.
     * </p>
     */
    private java.util.Date lastUpdatedDate;

    /**
     * <p>
     * The ID of the policy store that contains the policy that was updated.
     * </p>
     * 
     * @param policyStoreId
     *        The ID of the policy store that contains the policy that was updated.
     */

    public void setPolicyStoreId(String policyStoreId) {
        this.policyStoreId = policyStoreId;
    }

    /**
     * <p>
     * The ID of the policy store that contains the policy that was updated.
     * </p>
     * 
     * @return The ID of the policy store that contains the policy that was updated.
     */

    public String getPolicyStoreId() {
        return this.policyStoreId;
    }

    /**
     * <p>
     * The ID of the policy store that contains the policy that was updated.
     * </p>
     * 
     * @param policyStoreId
     *        The ID of the policy store that contains the policy that was updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdatePolicyResult withPolicyStoreId(String policyStoreId) {
        setPolicyStoreId(policyStoreId);
        return this;
    }

    /**
     * <p>
     * The ID of the policy that was updated.
     * </p>
     * 
     * @param policyId
     *        The ID of the policy that was updated.
     */

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    /**
     * <p>
     * The ID of the policy that was updated.
     * </p>
     * 
     * @return The ID of the policy that was updated.
     */

    public String getPolicyId() {
        return this.policyId;
    }

    /**
     * <p>
     * The ID of the policy that was updated.
     * </p>
     * 
     * @param policyId
     *        The ID of the policy that was updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdatePolicyResult withPolicyId(String policyId) {
        setPolicyId(policyId);
        return this;
    }

    /**
     * <p>
     * The type of the policy that was updated.
     * </p>
     * 
     * @param policyType
     *        The type of the policy that was updated.
     * @see PolicyType
     */

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    /**
     * <p>
     * The type of the policy that was updated.
     * </p>
     * 
     * @return The type of the policy that was updated.
     * @see PolicyType
     */

    public String getPolicyType() {
        return this.policyType;
    }

    /**
     * <p>
     * The type of the policy that was updated.
     * </p>
     * 
     * @param policyType
     *        The type of the policy that was updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PolicyType
     */

    public UpdatePolicyResult withPolicyType(String policyType) {
        setPolicyType(policyType);
        return this;
    }

    /**
     * <p>
     * The type of the policy that was updated.
     * </p>
     * 
     * @param policyType
     *        The type of the policy that was updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PolicyType
     */

    public UpdatePolicyResult withPolicyType(PolicyType policyType) {
        this.policyType = policyType.toString();
        return this;
    }

    /**
     * <p>
     * The principal specified in the policy's scope. This element isn't included in the response when
     * <code>Principal</code> isn't present in the policy content.
     * </p>
     * 
     * @param principal
     *        The principal specified in the policy's scope. This element isn't included in the response when
     *        <code>Principal</code> isn't present in the policy content.
     */

    public void setPrincipal(EntityIdentifier principal) {
        this.principal = principal;
    }

    /**
     * <p>
     * The principal specified in the policy's scope. This element isn't included in the response when
     * <code>Principal</code> isn't present in the policy content.
     * </p>
     * 
     * @return The principal specified in the policy's scope. This element isn't included in the response when
     *         <code>Principal</code> isn't present in the policy content.
     */

    public EntityIdentifier getPrincipal() {
        return this.principal;
    }

    /**
     * <p>
     * The principal specified in the policy's scope. This element isn't included in the response when
     * <code>Principal</code> isn't present in the policy content.
     * </p>
     * 
     * @param principal
     *        The principal specified in the policy's scope. This element isn't included in the response when
     *        <code>Principal</code> isn't present in the policy content.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdatePolicyResult withPrincipal(EntityIdentifier principal) {
        setPrincipal(principal);
        return this;
    }

    /**
     * <p>
     * The resource specified in the policy's scope. This element isn't included in the response when
     * <code>Resource</code> isn't present in the policy content.
     * </p>
     * 
     * @param resource
     *        The resource specified in the policy's scope. This element isn't included in the response when
     *        <code>Resource</code> isn't present in the policy content.
     */

    public void setResource(EntityIdentifier resource) {
        this.resource = resource;
    }

    /**
     * <p>
     * The resource specified in the policy's scope. This element isn't included in the response when
     * <code>Resource</code> isn't present in the policy content.
     * </p>
     * 
     * @return The resource specified in the policy's scope. This element isn't included in the response when
     *         <code>Resource</code> isn't present in the policy content.
     */

    public EntityIdentifier getResource() {
        return this.resource;
    }

    /**
     * <p>
     * The resource specified in the policy's scope. This element isn't included in the response when
     * <code>Resource</code> isn't present in the policy content.
     * </p>
     * 
     * @param resource
     *        The resource specified in the policy's scope. This element isn't included in the response when
     *        <code>Resource</code> isn't present in the policy content.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdatePolicyResult withResource(EntityIdentifier resource) {
        setResource(resource);
        return this;
    }

    /**
     * <p>
     * The date and time that the policy was originally created.
     * </p>
     * 
     * @param createdDate
     *        The date and time that the policy was originally created.
     */

    public void setCreatedDate(java.util.Date createdDate) {
        this.createdDate = createdDate;
    }

    /**
     * <p>
     * The date and time that the policy was originally created.
     * </p>
     * 
     * @return The date and time that the policy was originally created.
     */

    public java.util.Date getCreatedDate() {
        return this.createdDate;
    }

    /**
     * <p>
     * The date and time that the policy was originally created.
     * </p>
     * 
     * @param createdDate
     *        The date and time that the policy was originally created.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdatePolicyResult withCreatedDate(java.util.Date createdDate) {
        setCreatedDate(createdDate);
        return this;
    }

    /**
     * <p>
     * The date and time that the policy was most recently updated.
     * </p>
     * 
     * @param lastUpdatedDate
     *        The date and time that the policy was most recently updated.
     */

    public void setLastUpdatedDate(java.util.Date lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    /**
     * <p>
     * The date and time that the policy was most recently updated.
     * </p>
     * 
     * @return The date and time that the policy was most recently updated.
     */

    public java.util.Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    /**
     * <p>
     * The date and time that the policy was most recently updated.
     * </p>
     * 
     * @param lastUpdatedDate
     *        The date and time that the policy was most recently updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdatePolicyResult withLastUpdatedDate(java.util.Date lastUpdatedDate) {
        setLastUpdatedDate(lastUpdatedDate);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPolicyStoreId() != null)
            sb.append("PolicyStoreId: ").append(getPolicyStoreId()).append(",");
        if (getPolicyId() != null)
            sb.append("PolicyId: ").append(getPolicyId()).append(",");
        if (getPolicyType() != null)
            sb.append("PolicyType: ").append(getPolicyType()).append(",");
        if (getPrincipal() != null)
            sb.append("Principal: ").append(getPrincipal()).append(",");
        if (getResource() != null)
            sb.append("Resource: ").append(getResource()).append(",");
        if (getCreatedDate() != null)
            sb.append("CreatedDate: ").append(getCreatedDate()).append(",");
        if (getLastUpdatedDate() != null)
            sb.append("LastUpdatedDate: ").append(getLastUpdatedDate());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdatePolicyResult == false)
            return false;
        UpdatePolicyResult other = (UpdatePolicyResult) obj;
        if (other.getPolicyStoreId() == null ^ this.getPolicyStoreId() == null)
            return false;
        if (other.getPolicyStoreId() != null && other.getPolicyStoreId().equals(this.getPolicyStoreId()) == false)
            return false;
        if (other.getPolicyId() == null ^ this.getPolicyId() == null)
            return false;
        if (other.getPolicyId() != null && other.getPolicyId().equals(this.getPolicyId()) == false)
            return false;
        if (other.getPolicyType() == null ^ this.getPolicyType() == null)
            return false;
        if (other.getPolicyType() != null && other.getPolicyType().equals(this.getPolicyType()) == false)
            return false;
        if (other.getPrincipal() == null ^ this.getPrincipal() == null)
            return false;
        if (other.getPrincipal() != null && other.getPrincipal().equals(this.getPrincipal()) == false)
            return false;
        if (other.getResource() == null ^ this.getResource() == null)
            return false;
        if (other.getResource() != null && other.getResource().equals(this.getResource()) == false)
            return false;
        if (other.getCreatedDate() == null ^ this.getCreatedDate() == null)
            return false;
        if (other.getCreatedDate() != null && other.getCreatedDate().equals(this.getCreatedDate()) == false)
            return false;
        if (other.getLastUpdatedDate() == null ^ this.getLastUpdatedDate() == null)
            return false;
        if (other.getLastUpdatedDate() != null && other.getLastUpdatedDate().equals(this.getLastUpdatedDate()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getPolicyStoreId() == null) ? 0 : getPolicyStoreId().hashCode());
        hashCode = prime * hashCode + ((getPolicyId() == null) ? 0 : getPolicyId().hashCode());
        hashCode = prime * hashCode + ((getPolicyType() == null) ? 0 : getPolicyType().hashCode());
        hashCode = prime * hashCode + ((getPrincipal() == null) ? 0 : getPrincipal().hashCode());
        hashCode = prime * hashCode + ((getResource() == null) ? 0 : getResource().hashCode());
        hashCode = prime * hashCode + ((getCreatedDate() == null) ? 0 : getCreatedDate().hashCode());
        hashCode = prime * hashCode + ((getLastUpdatedDate() == null) ? 0 : getLastUpdatedDate().hashCode());
        return hashCode;
    }

    @Override
    public UpdatePolicyResult clone() {
        try {
            return (UpdatePolicyResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
