/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.voiceid.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.voiceid.model.FraudDetectionAction;
import com.amazonaws.services.voiceid.model.transform.EnrollmentJobFraudDetectionConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EnrollmentJobFraudDetectionConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String fraudDetectionAction;
    private Integer riskThreshold;
    private List<String> watchlistIds;

    public void setFraudDetectionAction(String fraudDetectionAction) {
        this.fraudDetectionAction = fraudDetectionAction;
    }

    public String getFraudDetectionAction() {
        return this.fraudDetectionAction;
    }

    public EnrollmentJobFraudDetectionConfig withFraudDetectionAction(String fraudDetectionAction) {
        this.setFraudDetectionAction(fraudDetectionAction);
        return this;
    }

    public EnrollmentJobFraudDetectionConfig withFraudDetectionAction(FraudDetectionAction fraudDetectionAction) {
        this.fraudDetectionAction = fraudDetectionAction.toString();
        return this;
    }

    public void setRiskThreshold(Integer riskThreshold) {
        this.riskThreshold = riskThreshold;
    }

    public Integer getRiskThreshold() {
        return this.riskThreshold;
    }

    public EnrollmentJobFraudDetectionConfig withRiskThreshold(Integer riskThreshold) {
        this.setRiskThreshold(riskThreshold);
        return this;
    }

    public List<String> getWatchlistIds() {
        return this.watchlistIds;
    }

    public void setWatchlistIds(Collection<String> watchlistIds) {
        if (watchlistIds == null) {
            this.watchlistIds = null;
            return;
        }
        this.watchlistIds = new ArrayList<String>(watchlistIds);
    }

    public EnrollmentJobFraudDetectionConfig withWatchlistIds(String ... watchlistIds) {
        if (this.watchlistIds == null) {
            this.setWatchlistIds(new ArrayList<String>(watchlistIds.length));
        }
        for (String ele : watchlistIds) {
            this.watchlistIds.add(ele);
        }
        return this;
    }

    public EnrollmentJobFraudDetectionConfig withWatchlistIds(Collection<String> watchlistIds) {
        this.setWatchlistIds(watchlistIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFraudDetectionAction() != null) {
            sb.append("FraudDetectionAction: ").append(this.getFraudDetectionAction()).append(",");
        }
        if (this.getRiskThreshold() != null) {
            sb.append("RiskThreshold: ").append(this.getRiskThreshold()).append(",");
        }
        if (this.getWatchlistIds() != null) {
            sb.append("WatchlistIds: ").append(this.getWatchlistIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnrollmentJobFraudDetectionConfig)) {
            return false;
        }
        EnrollmentJobFraudDetectionConfig other = (EnrollmentJobFraudDetectionConfig)obj;
        if (other.getFraudDetectionAction() == null ^ this.getFraudDetectionAction() == null) {
            return false;
        }
        if (other.getFraudDetectionAction() != null && !other.getFraudDetectionAction().equals(this.getFraudDetectionAction())) {
            return false;
        }
        if (other.getRiskThreshold() == null ^ this.getRiskThreshold() == null) {
            return false;
        }
        if (other.getRiskThreshold() != null && !other.getRiskThreshold().equals(this.getRiskThreshold())) {
            return false;
        }
        if (other.getWatchlistIds() == null ^ this.getWatchlistIds() == null) {
            return false;
        }
        return other.getWatchlistIds() == null || other.getWatchlistIds().equals(this.getWatchlistIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFraudDetectionAction() == null ? 0 : this.getFraudDetectionAction().hashCode());
        hashCode = 31 * hashCode + (this.getRiskThreshold() == null ? 0 : this.getRiskThreshold().hashCode());
        hashCode = 31 * hashCode + (this.getWatchlistIds() == null ? 0 : this.getWatchlistIds().hashCode());
        return hashCode;
    }

    public EnrollmentJobFraudDetectionConfig clone() {
        try {
            return (EnrollmentJobFraudDetectionConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnrollmentJobFraudDetectionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

