/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.voiceid.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/voice-id-2021-09-27/UpdateWatchlist" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateWatchlistRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A brief description about this watchlist.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The identifier of the domain that contains the watchlist.
     * </p>
     */
    private String domainId;
    /**
     * <p>
     * The name of the watchlist.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The identifier of the watchlist to be updated.
     * </p>
     */
    private String watchlistId;

    /**
     * <p>
     * A brief description about this watchlist.
     * </p>
     * 
     * @param description
     *        A brief description about this watchlist.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A brief description about this watchlist.
     * </p>
     * 
     * @return A brief description about this watchlist.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A brief description about this watchlist.
     * </p>
     * 
     * @param description
     *        A brief description about this watchlist.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateWatchlistRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The identifier of the domain that contains the watchlist.
     * </p>
     * 
     * @param domainId
     *        The identifier of the domain that contains the watchlist.
     */

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    /**
     * <p>
     * The identifier of the domain that contains the watchlist.
     * </p>
     * 
     * @return The identifier of the domain that contains the watchlist.
     */

    public String getDomainId() {
        return this.domainId;
    }

    /**
     * <p>
     * The identifier of the domain that contains the watchlist.
     * </p>
     * 
     * @param domainId
     *        The identifier of the domain that contains the watchlist.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateWatchlistRequest withDomainId(String domainId) {
        setDomainId(domainId);
        return this;
    }

    /**
     * <p>
     * The name of the watchlist.
     * </p>
     * 
     * @param name
     *        The name of the watchlist.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the watchlist.
     * </p>
     * 
     * @return The name of the watchlist.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the watchlist.
     * </p>
     * 
     * @param name
     *        The name of the watchlist.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateWatchlistRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The identifier of the watchlist to be updated.
     * </p>
     * 
     * @param watchlistId
     *        The identifier of the watchlist to be updated.
     */

    public void setWatchlistId(String watchlistId) {
        this.watchlistId = watchlistId;
    }

    /**
     * <p>
     * The identifier of the watchlist to be updated.
     * </p>
     * 
     * @return The identifier of the watchlist to be updated.
     */

    public String getWatchlistId() {
        return this.watchlistId;
    }

    /**
     * <p>
     * The identifier of the watchlist to be updated.
     * </p>
     * 
     * @param watchlistId
     *        The identifier of the watchlist to be updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateWatchlistRequest withWatchlistId(String watchlistId) {
        setWatchlistId(watchlistId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDescription() != null)
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        if (getDomainId() != null)
            sb.append("DomainId: ").append(getDomainId()).append(",");
        if (getName() != null)
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        if (getWatchlistId() != null)
            sb.append("WatchlistId: ").append(getWatchlistId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateWatchlistRequest == false)
            return false;
        UpdateWatchlistRequest other = (UpdateWatchlistRequest) obj;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getDomainId() == null ^ this.getDomainId() == null)
            return false;
        if (other.getDomainId() != null && other.getDomainId().equals(this.getDomainId()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getWatchlistId() == null ^ this.getWatchlistId() == null)
            return false;
        if (other.getWatchlistId() != null && other.getWatchlistId().equals(this.getWatchlistId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getDomainId() == null) ? 0 : getDomainId().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getWatchlistId() == null) ? 0 : getWatchlistId().hashCode());
        return hashCode;
    }

    @Override
    public UpdateWatchlistRequest clone() {
        return (UpdateWatchlistRequest) super.clone();
    }

}
