/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.waf.AWSWAF;
import com.amazonaws.services.waf.model.CreateByteMatchSetRequest;
import com.amazonaws.services.waf.model.CreateByteMatchSetResult;
import com.amazonaws.services.waf.model.CreateIPSetRequest;
import com.amazonaws.services.waf.model.CreateIPSetResult;
import com.amazonaws.services.waf.model.CreateRuleRequest;
import com.amazonaws.services.waf.model.CreateRuleResult;
import com.amazonaws.services.waf.model.CreateSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.CreateSqlInjectionMatchSetResult;
import com.amazonaws.services.waf.model.CreateWebACLRequest;
import com.amazonaws.services.waf.model.CreateWebACLResult;
import com.amazonaws.services.waf.model.DeleteByteMatchSetRequest;
import com.amazonaws.services.waf.model.DeleteByteMatchSetResult;
import com.amazonaws.services.waf.model.DeleteIPSetRequest;
import com.amazonaws.services.waf.model.DeleteIPSetResult;
import com.amazonaws.services.waf.model.DeleteRuleRequest;
import com.amazonaws.services.waf.model.DeleteRuleResult;
import com.amazonaws.services.waf.model.DeleteSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.DeleteSqlInjectionMatchSetResult;
import com.amazonaws.services.waf.model.DeleteWebACLRequest;
import com.amazonaws.services.waf.model.DeleteWebACLResult;
import com.amazonaws.services.waf.model.GetByteMatchSetRequest;
import com.amazonaws.services.waf.model.GetByteMatchSetResult;
import com.amazonaws.services.waf.model.GetChangeTokenRequest;
import com.amazonaws.services.waf.model.GetChangeTokenResult;
import com.amazonaws.services.waf.model.GetChangeTokenStatusRequest;
import com.amazonaws.services.waf.model.GetChangeTokenStatusResult;
import com.amazonaws.services.waf.model.GetIPSetRequest;
import com.amazonaws.services.waf.model.GetIPSetResult;
import com.amazonaws.services.waf.model.GetRuleRequest;
import com.amazonaws.services.waf.model.GetRuleResult;
import com.amazonaws.services.waf.model.GetSampledRequestsRequest;
import com.amazonaws.services.waf.model.GetSampledRequestsResult;
import com.amazonaws.services.waf.model.GetSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.GetSqlInjectionMatchSetResult;
import com.amazonaws.services.waf.model.GetWebACLRequest;
import com.amazonaws.services.waf.model.GetWebACLResult;
import com.amazonaws.services.waf.model.ListByteMatchSetsRequest;
import com.amazonaws.services.waf.model.ListByteMatchSetsResult;
import com.amazonaws.services.waf.model.ListIPSetsRequest;
import com.amazonaws.services.waf.model.ListIPSetsResult;
import com.amazonaws.services.waf.model.ListRulesRequest;
import com.amazonaws.services.waf.model.ListRulesResult;
import com.amazonaws.services.waf.model.ListSqlInjectionMatchSetsRequest;
import com.amazonaws.services.waf.model.ListSqlInjectionMatchSetsResult;
import com.amazonaws.services.waf.model.ListWebACLsRequest;
import com.amazonaws.services.waf.model.ListWebACLsResult;
import com.amazonaws.services.waf.model.UpdateByteMatchSetRequest;
import com.amazonaws.services.waf.model.UpdateByteMatchSetResult;
import com.amazonaws.services.waf.model.UpdateIPSetRequest;
import com.amazonaws.services.waf.model.UpdateIPSetResult;
import com.amazonaws.services.waf.model.UpdateRuleRequest;
import com.amazonaws.services.waf.model.UpdateRuleResult;
import com.amazonaws.services.waf.model.UpdateSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.UpdateSqlInjectionMatchSetResult;
import com.amazonaws.services.waf.model.UpdateWebACLRequest;
import com.amazonaws.services.waf.model.UpdateWebACLResult;
import com.amazonaws.services.waf.model.WAFDisallowedNameException;
import com.amazonaws.services.waf.model.WAFInternalErrorException;
import com.amazonaws.services.waf.model.WAFInvalidAccountException;
import com.amazonaws.services.waf.model.WAFInvalidOperationException;
import com.amazonaws.services.waf.model.WAFInvalidParameterException;
import com.amazonaws.services.waf.model.WAFLimitsExceededException;
import com.amazonaws.services.waf.model.WAFNonEmptyEntityException;
import com.amazonaws.services.waf.model.WAFNonexistentContainerException;
import com.amazonaws.services.waf.model.WAFNonexistentItemException;
import com.amazonaws.services.waf.model.WAFReferencedItemException;
import com.amazonaws.services.waf.model.WAFStaleDataException;
import com.amazonaws.services.waf.model.transform.CreateByteMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.CreateByteMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.CreateIPSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.CreateIPSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.CreateRuleRequestMarshaller;
import com.amazonaws.services.waf.model.transform.CreateRuleResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.CreateSqlInjectionMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.CreateSqlInjectionMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.CreateWebACLRequestMarshaller;
import com.amazonaws.services.waf.model.transform.CreateWebACLResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.DeleteByteMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.DeleteByteMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.DeleteIPSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.DeleteIPSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.DeleteRuleRequestMarshaller;
import com.amazonaws.services.waf.model.transform.DeleteRuleResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.DeleteSqlInjectionMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.DeleteSqlInjectionMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.DeleteWebACLRequestMarshaller;
import com.amazonaws.services.waf.model.transform.DeleteWebACLResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetByteMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetByteMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetChangeTokenRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetChangeTokenResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetChangeTokenStatusRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetChangeTokenStatusResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetIPSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetIPSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetRuleRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetRuleResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetSampledRequestsRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetSampledRequestsResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetSqlInjectionMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetSqlInjectionMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.GetWebACLRequestMarshaller;
import com.amazonaws.services.waf.model.transform.GetWebACLResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.ListByteMatchSetsRequestMarshaller;
import com.amazonaws.services.waf.model.transform.ListByteMatchSetsResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.ListIPSetsRequestMarshaller;
import com.amazonaws.services.waf.model.transform.ListIPSetsResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.ListRulesRequestMarshaller;
import com.amazonaws.services.waf.model.transform.ListRulesResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.ListSqlInjectionMatchSetsRequestMarshaller;
import com.amazonaws.services.waf.model.transform.ListSqlInjectionMatchSetsResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.ListWebACLsRequestMarshaller;
import com.amazonaws.services.waf.model.transform.ListWebACLsResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.UpdateByteMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.UpdateByteMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.UpdateIPSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.UpdateIPSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.UpdateRuleRequestMarshaller;
import com.amazonaws.services.waf.model.transform.UpdateRuleResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.UpdateSqlInjectionMatchSetRequestMarshaller;
import com.amazonaws.services.waf.model.transform.UpdateSqlInjectionMatchSetResultJsonUnmarshaller;
import com.amazonaws.services.waf.model.transform.UpdateWebACLRequestMarshaller;
import com.amazonaws.services.waf.model.transform.UpdateWebACLResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSWAFClient
extends AmazonWebServiceClient
implements AWSWAF {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSWAF.class);
    private static final String DEFAULT_SIGNING_NAME = "waf";
    private static final String DEFAULT_ENDPOINT_PREFIX = "waf";
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AWSWAFClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), PredefinedClientConfigurations.defaultConfig());
    }

    public AWSWAFClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSWAFClient(AWSCredentials awsCredentials) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig());
    }

    public AWSWAFClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSWAFClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig());
    }

    public AWSWAFClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSWAFClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFInternalErrorException.class, "WAFInternalErrorException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFReferencedItemException.class, "WAFReferencedItemException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFInvalidAccountException.class, "WAFInvalidAccountException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFStaleDataException.class, "WAFStaleDataException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFNonexistentContainerException.class, "WAFNonexistentContainerException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFLimitsExceededException.class, "WAFLimitsExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFInvalidParameterException.class, "WAFInvalidParameterException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFNonEmptyEntityException.class, "WAFNonEmptyEntityException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFDisallowedNameException.class, "WAFDisallowedNameException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFInvalidOperationException.class, "WAFInvalidOperationException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(WAFNonexistentItemException.class, "WAFNonexistentItemException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setServiceNameIntern("waf");
        this.setEndpointPrefix("waf");
        this.setEndpoint("https://waf.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/waf/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/waf/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateByteMatchSetResult createByteMatchSet(CreateByteMatchSetRequest createByteMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createByteMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateByteMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateByteMatchSetRequestMarshaller().marshall((CreateByteMatchSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createByteMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateByteMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateByteMatchSetResult createByteMatchSetResult = (CreateByteMatchSetResult)response.getAwsResponse();
            return createByteMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIPSetResult createIPSet(CreateIPSetRequest createIPSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createIPSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateIPSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateIPSetRequestMarshaller().marshall((CreateIPSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createIPSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateIPSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateIPSetResult createIPSetResult = (CreateIPSetResult)response.getAwsResponse();
            return createIPSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRuleResult createRule(CreateRuleRequest createRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRuleRequestMarshaller().marshall((CreateRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)createRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateRuleResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateRuleResult createRuleResult = (CreateRuleResult)response.getAwsResponse();
            return createRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSqlInjectionMatchSetResult createSqlInjectionMatchSet(CreateSqlInjectionMatchSetRequest createSqlInjectionMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createSqlInjectionMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateSqlInjectionMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateSqlInjectionMatchSetRequestMarshaller().marshall((CreateSqlInjectionMatchSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createSqlInjectionMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateSqlInjectionMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateSqlInjectionMatchSetResult createSqlInjectionMatchSetResult = (CreateSqlInjectionMatchSetResult)response.getAwsResponse();
            return createSqlInjectionMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWebACLResult createWebACL(CreateWebACLRequest createWebACLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createWebACLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateWebACLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateWebACLRequestMarshaller().marshall((CreateWebACLRequest)super.beforeMarshalling((AmazonWebServiceRequest)createWebACLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateWebACLResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateWebACLResult createWebACLResult = (CreateWebACLResult)response.getAwsResponse();
            return createWebACLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteByteMatchSetResult deleteByteMatchSet(DeleteByteMatchSetRequest deleteByteMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteByteMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteByteMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteByteMatchSetRequestMarshaller().marshall((DeleteByteMatchSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteByteMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DeleteByteMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteByteMatchSetResult deleteByteMatchSetResult = (DeleteByteMatchSetResult)response.getAwsResponse();
            return deleteByteMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIPSetResult deleteIPSet(DeleteIPSetRequest deleteIPSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteIPSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteIPSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteIPSetRequestMarshaller().marshall((DeleteIPSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteIPSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DeleteIPSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteIPSetResult deleteIPSetResult = (DeleteIPSetResult)response.getAwsResponse();
            return deleteIPSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRuleResult deleteRule(DeleteRuleRequest deleteRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRuleRequestMarshaller().marshall((DeleteRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DeleteRuleResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteRuleResult deleteRuleResult = (DeleteRuleResult)response.getAwsResponse();
            return deleteRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSqlInjectionMatchSetResult deleteSqlInjectionMatchSet(DeleteSqlInjectionMatchSetRequest deleteSqlInjectionMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSqlInjectionMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSqlInjectionMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSqlInjectionMatchSetRequestMarshaller().marshall((DeleteSqlInjectionMatchSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSqlInjectionMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DeleteSqlInjectionMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteSqlInjectionMatchSetResult deleteSqlInjectionMatchSetResult = (DeleteSqlInjectionMatchSetResult)response.getAwsResponse();
            return deleteSqlInjectionMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWebACLResult deleteWebACL(DeleteWebACLRequest deleteWebACLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteWebACLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteWebACLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteWebACLRequestMarshaller().marshall((DeleteWebACLRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteWebACLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DeleteWebACLResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteWebACLResult deleteWebACLResult = (DeleteWebACLResult)response.getAwsResponse();
            return deleteWebACLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetByteMatchSetResult getByteMatchSet(GetByteMatchSetRequest getByteMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getByteMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetByteMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetByteMatchSetRequestMarshaller().marshall((GetByteMatchSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)getByteMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetByteMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetByteMatchSetResult getByteMatchSetResult = (GetByteMatchSetResult)response.getAwsResponse();
            return getByteMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChangeTokenResult getChangeToken(GetChangeTokenRequest getChangeTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChangeTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChangeTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChangeTokenRequestMarshaller().marshall((GetChangeTokenRequest)super.beforeMarshalling((AmazonWebServiceRequest)getChangeTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetChangeTokenResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetChangeTokenResult getChangeTokenResult = (GetChangeTokenResult)response.getAwsResponse();
            return getChangeTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChangeTokenStatusResult getChangeTokenStatus(GetChangeTokenStatusRequest getChangeTokenStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChangeTokenStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChangeTokenStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChangeTokenStatusRequestMarshaller().marshall((GetChangeTokenStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getChangeTokenStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetChangeTokenStatusResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetChangeTokenStatusResult getChangeTokenStatusResult = (GetChangeTokenStatusResult)response.getAwsResponse();
            return getChangeTokenStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIPSetResult getIPSet(GetIPSetRequest getIPSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIPSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIPSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIPSetRequestMarshaller().marshall((GetIPSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)getIPSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetIPSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetIPSetResult getIPSetResult = (GetIPSetResult)response.getAwsResponse();
            return getIPSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRuleResult getRule(GetRuleRequest getRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRuleRequestMarshaller().marshall((GetRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetRuleResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetRuleResult getRuleResult = (GetRuleResult)response.getAwsResponse();
            return getRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSampledRequestsResult getSampledRequests(GetSampledRequestsRequest getSampledRequestsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSampledRequestsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSampledRequestsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSampledRequestsRequestMarshaller().marshall((GetSampledRequestsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSampledRequestsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetSampledRequestsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetSampledRequestsResult getSampledRequestsResult = (GetSampledRequestsResult)response.getAwsResponse();
            return getSampledRequestsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSqlInjectionMatchSetResult getSqlInjectionMatchSet(GetSqlInjectionMatchSetRequest getSqlInjectionMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getSqlInjectionMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSqlInjectionMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetSqlInjectionMatchSetRequestMarshaller().marshall((GetSqlInjectionMatchSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)getSqlInjectionMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetSqlInjectionMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetSqlInjectionMatchSetResult getSqlInjectionMatchSetResult = (GetSqlInjectionMatchSetResult)response.getAwsResponse();
            return getSqlInjectionMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWebACLResult getWebACL(GetWebACLRequest getWebACLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getWebACLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetWebACLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetWebACLRequestMarshaller().marshall((GetWebACLRequest)super.beforeMarshalling((AmazonWebServiceRequest)getWebACLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetWebACLResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetWebACLResult getWebACLResult = (GetWebACLResult)response.getAwsResponse();
            return getWebACLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListByteMatchSetsResult listByteMatchSets(ListByteMatchSetsRequest listByteMatchSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listByteMatchSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListByteMatchSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListByteMatchSetsRequestMarshaller().marshall((ListByteMatchSetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listByteMatchSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListByteMatchSetsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListByteMatchSetsResult listByteMatchSetsResult = (ListByteMatchSetsResult)response.getAwsResponse();
            return listByteMatchSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIPSetsResult listIPSets(ListIPSetsRequest listIPSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIPSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIPSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIPSetsRequestMarshaller().marshall((ListIPSetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listIPSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListIPSetsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListIPSetsResult listIPSetsResult = (ListIPSetsResult)response.getAwsResponse();
            return listIPSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRulesResult listRules(ListRulesRequest listRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRulesRequestMarshaller().marshall((ListRulesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListRulesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListRulesResult listRulesResult = (ListRulesResult)response.getAwsResponse();
            return listRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSqlInjectionMatchSetsResult listSqlInjectionMatchSets(ListSqlInjectionMatchSetsRequest listSqlInjectionMatchSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSqlInjectionMatchSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSqlInjectionMatchSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSqlInjectionMatchSetsRequestMarshaller().marshall((ListSqlInjectionMatchSetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSqlInjectionMatchSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListSqlInjectionMatchSetsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListSqlInjectionMatchSetsResult listSqlInjectionMatchSetsResult = (ListSqlInjectionMatchSetsResult)response.getAwsResponse();
            return listSqlInjectionMatchSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWebACLsResult listWebACLs(ListWebACLsRequest listWebACLsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listWebACLsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListWebACLsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListWebACLsRequestMarshaller().marshall((ListWebACLsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listWebACLsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListWebACLsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListWebACLsResult listWebACLsResult = (ListWebACLsResult)response.getAwsResponse();
            return listWebACLsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateByteMatchSetResult updateByteMatchSet(UpdateByteMatchSetRequest updateByteMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateByteMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateByteMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateByteMatchSetRequestMarshaller().marshall((UpdateByteMatchSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateByteMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateByteMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateByteMatchSetResult updateByteMatchSetResult = (UpdateByteMatchSetResult)response.getAwsResponse();
            return updateByteMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIPSetResult updateIPSet(UpdateIPSetRequest updateIPSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateIPSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateIPSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateIPSetRequestMarshaller().marshall((UpdateIPSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateIPSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateIPSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateIPSetResult updateIPSetResult = (UpdateIPSetResult)response.getAwsResponse();
            return updateIPSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRuleResult updateRule(UpdateRuleRequest updateRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRuleRequestMarshaller().marshall((UpdateRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateRuleResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateRuleResult updateRuleResult = (UpdateRuleResult)response.getAwsResponse();
            return updateRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSqlInjectionMatchSetResult updateSqlInjectionMatchSet(UpdateSqlInjectionMatchSetRequest updateSqlInjectionMatchSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateSqlInjectionMatchSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateSqlInjectionMatchSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateSqlInjectionMatchSetRequestMarshaller().marshall((UpdateSqlInjectionMatchSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateSqlInjectionMatchSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateSqlInjectionMatchSetResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateSqlInjectionMatchSetResult updateSqlInjectionMatchSetResult = (UpdateSqlInjectionMatchSetResult)response.getAwsResponse();
            return updateSqlInjectionMatchSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWebACLResult updateWebACL(UpdateWebACLRequest updateWebACLRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateWebACLRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateWebACLRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateWebACLRequestMarshaller().marshall((UpdateWebACLRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateWebACLRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UpdateWebACLResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateWebACLResult updateWebACLResult = (UpdateWebACLResult)response.getAwsResponse();
            return updateWebACLResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

