/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.waf.model.ListWebACLsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListWebACLsRequestMarshaller
implements Marshaller<Request<ListWebACLsRequest>, ListWebACLsRequest> {
    public Request<ListWebACLsRequest> marshall(ListWebACLsRequest listWebACLsRequest) {
        if (listWebACLsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listWebACLsRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.ListWebACLs");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (listWebACLsRequest.getNextMarker() != null) {
                jsonGenerator.writeFieldName("NextMarker").writeValue(listWebACLsRequest.getNextMarker());
            }
            if (listWebACLsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue((long)listWebACLsRequest.getLimit().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

