/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.waf.model.UpdateXssMatchSetRequest;
import com.amazonaws.services.waf.model.XssMatchSetUpdate;
import com.amazonaws.services.waf.model.transform.XssMatchSetUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateXssMatchSetRequestMarshaller
implements Marshaller<Request<UpdateXssMatchSetRequest>, UpdateXssMatchSetRequest> {
    public Request<UpdateXssMatchSetRequest> marshall(UpdateXssMatchSetRequest updateXssMatchSetRequest) {
        if (updateXssMatchSetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateXssMatchSetRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.UpdateXssMatchSet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<XssMatchSetUpdate> updatesList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (updateXssMatchSetRequest.getXssMatchSetId() != null) {
                jsonGenerator.writeFieldName("XssMatchSetId").writeValue(updateXssMatchSetRequest.getXssMatchSetId());
            }
            if (updateXssMatchSetRequest.getChangeToken() != null) {
                jsonGenerator.writeFieldName("ChangeToken").writeValue(updateXssMatchSetRequest.getChangeToken());
            }
            if ((updatesList = updateXssMatchSetRequest.getUpdates()) != null) {
                jsonGenerator.writeFieldName("Updates");
                jsonGenerator.writeStartArray();
                for (XssMatchSetUpdate updatesListValue : updatesList) {
                    if (updatesListValue == null) continue;
                    XssMatchSetUpdateJsonMarshaller.getInstance().marshall(updatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

