/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.SampledHTTPRequest;
import com.amazonaws.services.waf.model.transform.HTTPRequestJsonMarshaller;

public class SampledHTTPRequestJsonMarshaller {
    private static SampledHTTPRequestJsonMarshaller instance;

    public void marshall(SampledHTTPRequest sampledHTTPRequest, StructuredJsonGenerator jsonGenerator) {
        if (sampledHTTPRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (sampledHTTPRequest.getRequest() != null) {
                jsonGenerator.writeFieldName("Request");
                HTTPRequestJsonMarshaller.getInstance().marshall(sampledHTTPRequest.getRequest(), jsonGenerator);
            }
            if (sampledHTTPRequest.getWeight() != null) {
                jsonGenerator.writeFieldName("Weight").writeValue(sampledHTTPRequest.getWeight().longValue());
            }
            if (sampledHTTPRequest.getTimestamp() != null) {
                jsonGenerator.writeFieldName("Timestamp").writeValue(sampledHTTPRequest.getTimestamp());
            }
            if (sampledHTTPRequest.getAction() != null) {
                jsonGenerator.writeFieldName("Action").writeValue(sampledHTTPRequest.getAction());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SampledHTTPRequestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SampledHTTPRequestJsonMarshaller();
        }
        return instance;
    }
}

