/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.waf.model.RuleUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateRuleRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String ruleId;
    private String changeToken;
    private List<RuleUpdate> updates;

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public UpdateRuleRequest withRuleId(String ruleId) {
        this.setRuleId(ruleId);
        return this;
    }

    public void setChangeToken(String changeToken) {
        this.changeToken = changeToken;
    }

    public String getChangeToken() {
        return this.changeToken;
    }

    public UpdateRuleRequest withChangeToken(String changeToken) {
        this.setChangeToken(changeToken);
        return this;
    }

    public List<RuleUpdate> getUpdates() {
        return this.updates;
    }

    public void setUpdates(Collection<RuleUpdate> updates) {
        if (updates == null) {
            this.updates = null;
            return;
        }
        this.updates = new ArrayList<RuleUpdate>(updates);
    }

    public UpdateRuleRequest withUpdates(RuleUpdate ... updates) {
        if (this.updates == null) {
            this.setUpdates(new ArrayList<RuleUpdate>(updates.length));
        }
        for (RuleUpdate ele : updates) {
            this.updates.add(ele);
        }
        return this;
    }

    public UpdateRuleRequest withUpdates(Collection<RuleUpdate> updates) {
        this.setUpdates(updates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleId() != null) {
            sb.append("RuleId: " + this.getRuleId() + ",");
        }
        if (this.getChangeToken() != null) {
            sb.append("ChangeToken: " + this.getChangeToken() + ",");
        }
        if (this.getUpdates() != null) {
            sb.append("Updates: " + this.getUpdates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRuleRequest)) {
            return false;
        }
        UpdateRuleRequest other = (UpdateRuleRequest)obj;
        if (other.getRuleId() == null ^ this.getRuleId() == null) {
            return false;
        }
        if (other.getRuleId() != null && !other.getRuleId().equals(this.getRuleId())) {
            return false;
        }
        if (other.getChangeToken() == null ^ this.getChangeToken() == null) {
            return false;
        }
        if (other.getChangeToken() != null && !other.getChangeToken().equals(this.getChangeToken())) {
            return false;
        }
        if (other.getUpdates() == null ^ this.getUpdates() == null) {
            return false;
        }
        return other.getUpdates() == null || other.getUpdates().equals(this.getUpdates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleId() == null ? 0 : this.getRuleId().hashCode());
        hashCode = 31 * hashCode + (this.getChangeToken() == null ? 0 : this.getChangeToken().hashCode());
        hashCode = 31 * hashCode + (this.getUpdates() == null ? 0 : this.getUpdates().hashCode());
        return hashCode;
    }

    public UpdateRuleRequest clone() {
        return (UpdateRuleRequest)super.clone();
    }
}

