/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.waf_regional.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.SqlInjectionMatchSetUpdate;
import com.amazonaws.services.waf.model.UpdateSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.waf_regional.transform.SqlInjectionMatchSetUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateSqlInjectionMatchSetRequestMarshaller
implements Marshaller<Request<UpdateSqlInjectionMatchSetRequest>, UpdateSqlInjectionMatchSetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateSqlInjectionMatchSetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateSqlInjectionMatchSetRequest> marshall(UpdateSqlInjectionMatchSetRequest updateSqlInjectionMatchSetRequest) {
        if (updateSqlInjectionMatchSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateSqlInjectionMatchSetRequest, "AWSWAFRegional");
        request.addHeader("X-Amz-Target", "AWSWAF_Regional_20161128.UpdateSqlInjectionMatchSet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<SqlInjectionMatchSetUpdate> updatesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateSqlInjectionMatchSetRequest.getSqlInjectionMatchSetId() != null) {
                jsonGenerator.writeFieldName("SqlInjectionMatchSetId").writeValue(updateSqlInjectionMatchSetRequest.getSqlInjectionMatchSetId());
            }
            if (updateSqlInjectionMatchSetRequest.getChangeToken() != null) {
                jsonGenerator.writeFieldName("ChangeToken").writeValue(updateSqlInjectionMatchSetRequest.getChangeToken());
            }
            if ((updatesList = updateSqlInjectionMatchSetRequest.getUpdates()) != null) {
                jsonGenerator.writeFieldName("Updates");
                jsonGenerator.writeStartArray();
                for (SqlInjectionMatchSetUpdate updatesListValue : updatesList) {
                    if (updatesListValue == null) continue;
                    SqlInjectionMatchSetUpdateJsonMarshaller.getInstance().marshall(updatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

