/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.waf_regional.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.waf.model.AssociateWebACLRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class AssociateWebACLRequestMarshaller
implements Marshaller<Request<AssociateWebACLRequest>, AssociateWebACLRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AssociateWebACLRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AssociateWebACLRequest> marshall(AssociateWebACLRequest associateWebACLRequest) {
        if (associateWebACLRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)associateWebACLRequest, "AWSWAFRegional");
        request.addHeader("X-Amz-Target", "AWSWAF_Regional_20161128.AssociateWebACL");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (associateWebACLRequest.getWebACLId() != null) {
                jsonGenerator.writeFieldName("WebACLId").writeValue(associateWebACLRequest.getWebACLId());
            }
            if (associateWebACLRequest.getResourceArn() != null) {
                jsonGenerator.writeFieldName("ResourceArn").writeValue(associateWebACLRequest.getResourceArn());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

