/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.JsonBody;

@SdkInternalApi
public class JsonBodyMarshaller {
    private static final MarshallingInfo<StructuredPojo> MATCHPATTERN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchPattern").build();
    private static final MarshallingInfo<String> MATCHSCOPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchScope").build();
    private static final MarshallingInfo<String> INVALIDFALLBACKBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvalidFallbackBehavior").build();
    private static final JsonBodyMarshaller instance = new JsonBodyMarshaller();

    public static JsonBodyMarshaller getInstance() {
        return instance;
    }

    public void marshall(JsonBody jsonBody, ProtocolMarshaller protocolMarshaller) {
        if (jsonBody == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jsonBody.getMatchPattern(), MATCHPATTERN_BINDING);
            protocolMarshaller.marshall((Object)jsonBody.getMatchScope(), MATCHSCOPE_BINDING);
            protocolMarshaller.marshall((Object)jsonBody.getInvalidFallbackBehavior(), INVALIDFALLBACKBEHAVIOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

