/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.CustomResponseBody;
import com.amazonaws.services.wafv2.model.Rule;
import com.amazonaws.services.wafv2.model.VisibilityConfig;
import com.amazonaws.services.wafv2.model.transform.RuleGroupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuleGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String id;
    private Long capacity;
    private String aRN;
    private String description;
    private List<Rule> rules;
    private VisibilityConfig visibilityConfig;
    private Map<String, CustomResponseBody> customResponseBodies;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RuleGroup withName(String name) {
        this.setName(name);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public RuleGroup withId(String id) {
        this.setId(id);
        return this;
    }

    public void setCapacity(Long capacity) {
        this.capacity = capacity;
    }

    public Long getCapacity() {
        return this.capacity;
    }

    public RuleGroup withCapacity(Long capacity) {
        this.setCapacity(capacity);
        return this;
    }

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public RuleGroup withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public RuleGroup withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<Rule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<Rule>(rules);
    }

    public RuleGroup withRules(Rule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<Rule>(rules.length));
        }
        for (Rule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public RuleGroup withRules(Collection<Rule> rules) {
        this.setRules(rules);
        return this;
    }

    public void setVisibilityConfig(VisibilityConfig visibilityConfig) {
        this.visibilityConfig = visibilityConfig;
    }

    public VisibilityConfig getVisibilityConfig() {
        return this.visibilityConfig;
    }

    public RuleGroup withVisibilityConfig(VisibilityConfig visibilityConfig) {
        this.setVisibilityConfig(visibilityConfig);
        return this;
    }

    public Map<String, CustomResponseBody> getCustomResponseBodies() {
        return this.customResponseBodies;
    }

    public void setCustomResponseBodies(Map<String, CustomResponseBody> customResponseBodies) {
        this.customResponseBodies = customResponseBodies;
    }

    public RuleGroup withCustomResponseBodies(Map<String, CustomResponseBody> customResponseBodies) {
        this.setCustomResponseBodies(customResponseBodies);
        return this;
    }

    public RuleGroup addCustomResponseBodiesEntry(String key, CustomResponseBody value) {
        if (null == this.customResponseBodies) {
            this.customResponseBodies = new HashMap<String, CustomResponseBody>();
        }
        if (this.customResponseBodies.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.customResponseBodies.put(key, value);
        return this;
    }

    public RuleGroup clearCustomResponseBodiesEntries() {
        this.customResponseBodies = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getCapacity() != null) {
            sb.append("Capacity: ").append(this.getCapacity()).append(",");
        }
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getVisibilityConfig() != null) {
            sb.append("VisibilityConfig: ").append(this.getVisibilityConfig()).append(",");
        }
        if (this.getCustomResponseBodies() != null) {
            sb.append("CustomResponseBodies: ").append(this.getCustomResponseBodies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroup)) {
            return false;
        }
        RuleGroup other = (RuleGroup)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getCapacity() == null ^ this.getCapacity() == null) {
            return false;
        }
        if (other.getCapacity() != null && !other.getCapacity().equals(this.getCapacity())) {
            return false;
        }
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getVisibilityConfig() == null ^ this.getVisibilityConfig() == null) {
            return false;
        }
        if (other.getVisibilityConfig() != null && !other.getVisibilityConfig().equals(this.getVisibilityConfig())) {
            return false;
        }
        if (other.getCustomResponseBodies() == null ^ this.getCustomResponseBodies() == null) {
            return false;
        }
        return other.getCustomResponseBodies() == null || other.getCustomResponseBodies().equals(this.getCustomResponseBodies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getCapacity() == null ? 0 : this.getCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getVisibilityConfig() == null ? 0 : this.getVisibilityConfig().hashCode());
        hashCode = 31 * hashCode + (this.getCustomResponseBodies() == null ? 0 : this.getCustomResponseBodies().hashCode());
        return hashCode;
    }

    public RuleGroup clone() {
        try {
            return (RuleGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

