/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.CaptchaConfig;
import com.amazonaws.services.wafv2.model.CustomResponseBody;
import com.amazonaws.services.wafv2.model.DefaultAction;
import com.amazonaws.services.wafv2.model.FirewallManagerRuleGroup;
import com.amazonaws.services.wafv2.model.Rule;
import com.amazonaws.services.wafv2.model.VisibilityConfig;
import com.amazonaws.services.wafv2.model.transform.WebACLMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebACL
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String id;
    private String aRN;
    private DefaultAction defaultAction;
    private String description;
    private List<Rule> rules;
    private VisibilityConfig visibilityConfig;
    private Long capacity;
    private List<FirewallManagerRuleGroup> preProcessFirewallManagerRuleGroups;
    private List<FirewallManagerRuleGroup> postProcessFirewallManagerRuleGroups;
    private Boolean managedByFirewallManager;
    private String labelNamespace;
    private Map<String, CustomResponseBody> customResponseBodies;
    private CaptchaConfig captchaConfig;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public WebACL withName(String name) {
        this.setName(name);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public WebACL withId(String id) {
        this.setId(id);
        return this;
    }

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public WebACL withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public void setDefaultAction(DefaultAction defaultAction) {
        this.defaultAction = defaultAction;
    }

    public DefaultAction getDefaultAction() {
        return this.defaultAction;
    }

    public WebACL withDefaultAction(DefaultAction defaultAction) {
        this.setDefaultAction(defaultAction);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public WebACL withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<Rule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<Rule>(rules);
    }

    public WebACL withRules(Rule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<Rule>(rules.length));
        }
        for (Rule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public WebACL withRules(Collection<Rule> rules) {
        this.setRules(rules);
        return this;
    }

    public void setVisibilityConfig(VisibilityConfig visibilityConfig) {
        this.visibilityConfig = visibilityConfig;
    }

    public VisibilityConfig getVisibilityConfig() {
        return this.visibilityConfig;
    }

    public WebACL withVisibilityConfig(VisibilityConfig visibilityConfig) {
        this.setVisibilityConfig(visibilityConfig);
        return this;
    }

    public void setCapacity(Long capacity) {
        this.capacity = capacity;
    }

    public Long getCapacity() {
        return this.capacity;
    }

    public WebACL withCapacity(Long capacity) {
        this.setCapacity(capacity);
        return this;
    }

    public List<FirewallManagerRuleGroup> getPreProcessFirewallManagerRuleGroups() {
        return this.preProcessFirewallManagerRuleGroups;
    }

    public void setPreProcessFirewallManagerRuleGroups(Collection<FirewallManagerRuleGroup> preProcessFirewallManagerRuleGroups) {
        if (preProcessFirewallManagerRuleGroups == null) {
            this.preProcessFirewallManagerRuleGroups = null;
            return;
        }
        this.preProcessFirewallManagerRuleGroups = new ArrayList<FirewallManagerRuleGroup>(preProcessFirewallManagerRuleGroups);
    }

    public WebACL withPreProcessFirewallManagerRuleGroups(FirewallManagerRuleGroup ... preProcessFirewallManagerRuleGroups) {
        if (this.preProcessFirewallManagerRuleGroups == null) {
            this.setPreProcessFirewallManagerRuleGroups(new ArrayList<FirewallManagerRuleGroup>(preProcessFirewallManagerRuleGroups.length));
        }
        for (FirewallManagerRuleGroup ele : preProcessFirewallManagerRuleGroups) {
            this.preProcessFirewallManagerRuleGroups.add(ele);
        }
        return this;
    }

    public WebACL withPreProcessFirewallManagerRuleGroups(Collection<FirewallManagerRuleGroup> preProcessFirewallManagerRuleGroups) {
        this.setPreProcessFirewallManagerRuleGroups(preProcessFirewallManagerRuleGroups);
        return this;
    }

    public List<FirewallManagerRuleGroup> getPostProcessFirewallManagerRuleGroups() {
        return this.postProcessFirewallManagerRuleGroups;
    }

    public void setPostProcessFirewallManagerRuleGroups(Collection<FirewallManagerRuleGroup> postProcessFirewallManagerRuleGroups) {
        if (postProcessFirewallManagerRuleGroups == null) {
            this.postProcessFirewallManagerRuleGroups = null;
            return;
        }
        this.postProcessFirewallManagerRuleGroups = new ArrayList<FirewallManagerRuleGroup>(postProcessFirewallManagerRuleGroups);
    }

    public WebACL withPostProcessFirewallManagerRuleGroups(FirewallManagerRuleGroup ... postProcessFirewallManagerRuleGroups) {
        if (this.postProcessFirewallManagerRuleGroups == null) {
            this.setPostProcessFirewallManagerRuleGroups(new ArrayList<FirewallManagerRuleGroup>(postProcessFirewallManagerRuleGroups.length));
        }
        for (FirewallManagerRuleGroup ele : postProcessFirewallManagerRuleGroups) {
            this.postProcessFirewallManagerRuleGroups.add(ele);
        }
        return this;
    }

    public WebACL withPostProcessFirewallManagerRuleGroups(Collection<FirewallManagerRuleGroup> postProcessFirewallManagerRuleGroups) {
        this.setPostProcessFirewallManagerRuleGroups(postProcessFirewallManagerRuleGroups);
        return this;
    }

    public void setManagedByFirewallManager(Boolean managedByFirewallManager) {
        this.managedByFirewallManager = managedByFirewallManager;
    }

    public Boolean getManagedByFirewallManager() {
        return this.managedByFirewallManager;
    }

    public WebACL withManagedByFirewallManager(Boolean managedByFirewallManager) {
        this.setManagedByFirewallManager(managedByFirewallManager);
        return this;
    }

    public Boolean isManagedByFirewallManager() {
        return this.managedByFirewallManager;
    }

    public void setLabelNamespace(String labelNamespace) {
        this.labelNamespace = labelNamespace;
    }

    public String getLabelNamespace() {
        return this.labelNamespace;
    }

    public WebACL withLabelNamespace(String labelNamespace) {
        this.setLabelNamespace(labelNamespace);
        return this;
    }

    public Map<String, CustomResponseBody> getCustomResponseBodies() {
        return this.customResponseBodies;
    }

    public void setCustomResponseBodies(Map<String, CustomResponseBody> customResponseBodies) {
        this.customResponseBodies = customResponseBodies;
    }

    public WebACL withCustomResponseBodies(Map<String, CustomResponseBody> customResponseBodies) {
        this.setCustomResponseBodies(customResponseBodies);
        return this;
    }

    public WebACL addCustomResponseBodiesEntry(String key, CustomResponseBody value) {
        if (null == this.customResponseBodies) {
            this.customResponseBodies = new HashMap<String, CustomResponseBody>();
        }
        if (this.customResponseBodies.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.customResponseBodies.put(key, value);
        return this;
    }

    public WebACL clearCustomResponseBodiesEntries() {
        this.customResponseBodies = null;
        return this;
    }

    public void setCaptchaConfig(CaptchaConfig captchaConfig) {
        this.captchaConfig = captchaConfig;
    }

    public CaptchaConfig getCaptchaConfig() {
        return this.captchaConfig;
    }

    public WebACL withCaptchaConfig(CaptchaConfig captchaConfig) {
        this.setCaptchaConfig(captchaConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN()).append(",");
        }
        if (this.getDefaultAction() != null) {
            sb.append("DefaultAction: ").append(this.getDefaultAction()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getVisibilityConfig() != null) {
            sb.append("VisibilityConfig: ").append(this.getVisibilityConfig()).append(",");
        }
        if (this.getCapacity() != null) {
            sb.append("Capacity: ").append(this.getCapacity()).append(",");
        }
        if (this.getPreProcessFirewallManagerRuleGroups() != null) {
            sb.append("PreProcessFirewallManagerRuleGroups: ").append(this.getPreProcessFirewallManagerRuleGroups()).append(",");
        }
        if (this.getPostProcessFirewallManagerRuleGroups() != null) {
            sb.append("PostProcessFirewallManagerRuleGroups: ").append(this.getPostProcessFirewallManagerRuleGroups()).append(",");
        }
        if (this.getManagedByFirewallManager() != null) {
            sb.append("ManagedByFirewallManager: ").append(this.getManagedByFirewallManager()).append(",");
        }
        if (this.getLabelNamespace() != null) {
            sb.append("LabelNamespace: ").append(this.getLabelNamespace()).append(",");
        }
        if (this.getCustomResponseBodies() != null) {
            sb.append("CustomResponseBodies: ").append(this.getCustomResponseBodies()).append(",");
        }
        if (this.getCaptchaConfig() != null) {
            sb.append("CaptchaConfig: ").append(this.getCaptchaConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACL)) {
            return false;
        }
        WebACL other = (WebACL)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getDefaultAction() == null ^ this.getDefaultAction() == null) {
            return false;
        }
        if (other.getDefaultAction() != null && !other.getDefaultAction().equals(this.getDefaultAction())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getVisibilityConfig() == null ^ this.getVisibilityConfig() == null) {
            return false;
        }
        if (other.getVisibilityConfig() != null && !other.getVisibilityConfig().equals(this.getVisibilityConfig())) {
            return false;
        }
        if (other.getCapacity() == null ^ this.getCapacity() == null) {
            return false;
        }
        if (other.getCapacity() != null && !other.getCapacity().equals(this.getCapacity())) {
            return false;
        }
        if (other.getPreProcessFirewallManagerRuleGroups() == null ^ this.getPreProcessFirewallManagerRuleGroups() == null) {
            return false;
        }
        if (other.getPreProcessFirewallManagerRuleGroups() != null && !other.getPreProcessFirewallManagerRuleGroups().equals(this.getPreProcessFirewallManagerRuleGroups())) {
            return false;
        }
        if (other.getPostProcessFirewallManagerRuleGroups() == null ^ this.getPostProcessFirewallManagerRuleGroups() == null) {
            return false;
        }
        if (other.getPostProcessFirewallManagerRuleGroups() != null && !other.getPostProcessFirewallManagerRuleGroups().equals(this.getPostProcessFirewallManagerRuleGroups())) {
            return false;
        }
        if (other.getManagedByFirewallManager() == null ^ this.getManagedByFirewallManager() == null) {
            return false;
        }
        if (other.getManagedByFirewallManager() != null && !other.getManagedByFirewallManager().equals(this.getManagedByFirewallManager())) {
            return false;
        }
        if (other.getLabelNamespace() == null ^ this.getLabelNamespace() == null) {
            return false;
        }
        if (other.getLabelNamespace() != null && !other.getLabelNamespace().equals(this.getLabelNamespace())) {
            return false;
        }
        if (other.getCustomResponseBodies() == null ^ this.getCustomResponseBodies() == null) {
            return false;
        }
        if (other.getCustomResponseBodies() != null && !other.getCustomResponseBodies().equals(this.getCustomResponseBodies())) {
            return false;
        }
        if (other.getCaptchaConfig() == null ^ this.getCaptchaConfig() == null) {
            return false;
        }
        return other.getCaptchaConfig() == null || other.getCaptchaConfig().equals(this.getCaptchaConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultAction() == null ? 0 : this.getDefaultAction().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getVisibilityConfig() == null ? 0 : this.getVisibilityConfig().hashCode());
        hashCode = 31 * hashCode + (this.getCapacity() == null ? 0 : this.getCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getPreProcessFirewallManagerRuleGroups() == null ? 0 : this.getPreProcessFirewallManagerRuleGroups().hashCode());
        hashCode = 31 * hashCode + (this.getPostProcessFirewallManagerRuleGroups() == null ? 0 : this.getPostProcessFirewallManagerRuleGroups().hashCode());
        hashCode = 31 * hashCode + (this.getManagedByFirewallManager() == null ? 0 : this.getManagedByFirewallManager().hashCode());
        hashCode = 31 * hashCode + (this.getLabelNamespace() == null ? 0 : this.getLabelNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getCustomResponseBodies() == null ? 0 : this.getCustomResponseBodies().hashCode());
        hashCode = 31 * hashCode + (this.getCaptchaConfig() == null ? 0 : this.getCaptchaConfig().hashCode());
        return hashCode;
    }

    public WebACL clone() {
        try {
            return (WebACL)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebACLMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

