/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.SampledHTTPRequest;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class SampledHTTPRequestMarshaller {
    private static final MarshallingInfo<StructuredPojo> REQUEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Request").build();
    private static final MarshallingInfo<Long> WEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Weight").build();
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<String> RULENAMEWITHINRULEGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleNameWithinRuleGroup").build();
    private static final MarshallingInfo<List> REQUESTHEADERSINSERTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestHeadersInserted").build();
    private static final MarshallingInfo<Integer> RESPONSECODESENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseCodeSent").build();
    private static final MarshallingInfo<List> LABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Labels").build();
    private static final SampledHTTPRequestMarshaller instance = new SampledHTTPRequestMarshaller();

    public static SampledHTTPRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(SampledHTTPRequest sampledHTTPRequest, ProtocolMarshaller protocolMarshaller) {
        if (sampledHTTPRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sampledHTTPRequest.getRequest(), REQUEST_BINDING);
            protocolMarshaller.marshall((Object)sampledHTTPRequest.getWeight(), WEIGHT_BINDING);
            protocolMarshaller.marshall((Object)sampledHTTPRequest.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)sampledHTTPRequest.getAction(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)sampledHTTPRequest.getRuleNameWithinRuleGroup(), RULENAMEWITHINRULEGROUP_BINDING);
            protocolMarshaller.marshall(sampledHTTPRequest.getRequestHeadersInserted(), REQUESTHEADERSINSERTED_BINDING);
            protocolMarshaller.marshall((Object)sampledHTTPRequest.getResponseCodeSent(), RESPONSECODESENT_BINDING);
            protocolMarshaller.marshall(sampledHTTPRequest.getLabels(), LABELS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

