/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.All;
import com.amazonaws.services.wafv2.model.transform.CookieMatchPatternMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CookieMatchPattern
implements Serializable,
Cloneable,
StructuredPojo {
    private All all;
    private List<String> includedCookies;
    private List<String> excludedCookies;

    public void setAll(All all) {
        this.all = all;
    }

    public All getAll() {
        return this.all;
    }

    public CookieMatchPattern withAll(All all) {
        this.setAll(all);
        return this;
    }

    public List<String> getIncludedCookies() {
        return this.includedCookies;
    }

    public void setIncludedCookies(Collection<String> includedCookies) {
        if (includedCookies == null) {
            this.includedCookies = null;
            return;
        }
        this.includedCookies = new ArrayList<String>(includedCookies);
    }

    public CookieMatchPattern withIncludedCookies(String ... includedCookies) {
        if (this.includedCookies == null) {
            this.setIncludedCookies(new ArrayList<String>(includedCookies.length));
        }
        for (String ele : includedCookies) {
            this.includedCookies.add(ele);
        }
        return this;
    }

    public CookieMatchPattern withIncludedCookies(Collection<String> includedCookies) {
        this.setIncludedCookies(includedCookies);
        return this;
    }

    public List<String> getExcludedCookies() {
        return this.excludedCookies;
    }

    public void setExcludedCookies(Collection<String> excludedCookies) {
        if (excludedCookies == null) {
            this.excludedCookies = null;
            return;
        }
        this.excludedCookies = new ArrayList<String>(excludedCookies);
    }

    public CookieMatchPattern withExcludedCookies(String ... excludedCookies) {
        if (this.excludedCookies == null) {
            this.setExcludedCookies(new ArrayList<String>(excludedCookies.length));
        }
        for (String ele : excludedCookies) {
            this.excludedCookies.add(ele);
        }
        return this;
    }

    public CookieMatchPattern withExcludedCookies(Collection<String> excludedCookies) {
        this.setExcludedCookies(excludedCookies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAll() != null) {
            sb.append("All: ").append(this.getAll()).append(",");
        }
        if (this.getIncludedCookies() != null) {
            sb.append("IncludedCookies: ").append(this.getIncludedCookies()).append(",");
        }
        if (this.getExcludedCookies() != null) {
            sb.append("ExcludedCookies: ").append(this.getExcludedCookies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookieMatchPattern)) {
            return false;
        }
        CookieMatchPattern other = (CookieMatchPattern)obj;
        if (other.getAll() == null ^ this.getAll() == null) {
            return false;
        }
        if (other.getAll() != null && !other.getAll().equals(this.getAll())) {
            return false;
        }
        if (other.getIncludedCookies() == null ^ this.getIncludedCookies() == null) {
            return false;
        }
        if (other.getIncludedCookies() != null && !other.getIncludedCookies().equals(this.getIncludedCookies())) {
            return false;
        }
        if (other.getExcludedCookies() == null ^ this.getExcludedCookies() == null) {
            return false;
        }
        return other.getExcludedCookies() == null || other.getExcludedCookies().equals(this.getExcludedCookies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAll() == null ? 0 : this.getAll().hashCode());
        hashCode = 31 * hashCode + (this.getIncludedCookies() == null ? 0 : this.getIncludedCookies().hashCode());
        hashCode = 31 * hashCode + (this.getExcludedCookies() == null ? 0 : this.getExcludedCookies().hashCode());
        return hashCode;
    }

    public CookieMatchPattern clone() {
        try {
            return (CookieMatchPattern)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CookieMatchPatternMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

