/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.Filter;
import com.amazonaws.services.wafv2.model.FilterBehavior;
import com.amazonaws.services.wafv2.model.transform.LoggingFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LoggingFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Filter> filters;
    private String defaultBehavior;

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<Filter>(filters);
    }

    public LoggingFilter withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public LoggingFilter withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setDefaultBehavior(String defaultBehavior) {
        this.defaultBehavior = defaultBehavior;
    }

    public String getDefaultBehavior() {
        return this.defaultBehavior;
    }

    public LoggingFilter withDefaultBehavior(String defaultBehavior) {
        this.setDefaultBehavior(defaultBehavior);
        return this;
    }

    public LoggingFilter withDefaultBehavior(FilterBehavior defaultBehavior) {
        this.defaultBehavior = defaultBehavior.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getDefaultBehavior() != null) {
            sb.append("DefaultBehavior: ").append(this.getDefaultBehavior());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingFilter)) {
            return false;
        }
        LoggingFilter other = (LoggingFilter)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getDefaultBehavior() == null ^ this.getDefaultBehavior() == null) {
            return false;
        }
        return other.getDefaultBehavior() == null || other.getDefaultBehavior().equals(this.getDefaultBehavior());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultBehavior() == null ? 0 : this.getDefaultBehavior().hashCode());
        return hashCode;
    }

    public LoggingFilter clone() {
        try {
            return (LoggingFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggingFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

