/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.wellarchitected.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListReviewTemplates"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListReviewTemplatesResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * List of review templates.
     * </p>
     */
    private java.util.List<ReviewTemplateSummary> reviewTemplates;

    private String nextToken;

    /**
     * <p>
     * List of review templates.
     * </p>
     * 
     * @return List of review templates.
     */

    public java.util.List<ReviewTemplateSummary> getReviewTemplates() {
        return reviewTemplates;
    }

    /**
     * <p>
     * List of review templates.
     * </p>
     * 
     * @param reviewTemplates
     *        List of review templates.
     */

    public void setReviewTemplates(java.util.Collection<ReviewTemplateSummary> reviewTemplates) {
        if (reviewTemplates == null) {
            this.reviewTemplates = null;
            return;
        }

        this.reviewTemplates = new java.util.ArrayList<ReviewTemplateSummary>(reviewTemplates);
    }

    /**
     * <p>
     * List of review templates.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setReviewTemplates(java.util.Collection)} or {@link #withReviewTemplates(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param reviewTemplates
     *        List of review templates.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListReviewTemplatesResult withReviewTemplates(ReviewTemplateSummary... reviewTemplates) {
        if (this.reviewTemplates == null) {
            setReviewTemplates(new java.util.ArrayList<ReviewTemplateSummary>(reviewTemplates.length));
        }
        for (ReviewTemplateSummary ele : reviewTemplates) {
            this.reviewTemplates.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * List of review templates.
     * </p>
     * 
     * @param reviewTemplates
     *        List of review templates.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListReviewTemplatesResult withReviewTemplates(java.util.Collection<ReviewTemplateSummary> reviewTemplates) {
        setReviewTemplates(reviewTemplates);
        return this;
    }

    /**
     * @param nextToken
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * @return
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * @param nextToken
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListReviewTemplatesResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getReviewTemplates() != null)
            sb.append("ReviewTemplates: ").append(getReviewTemplates()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListReviewTemplatesResult == false)
            return false;
        ListReviewTemplatesResult other = (ListReviewTemplatesResult) obj;
        if (other.getReviewTemplates() == null ^ this.getReviewTemplates() == null)
            return false;
        if (other.getReviewTemplates() != null && other.getReviewTemplates().equals(this.getReviewTemplates()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getReviewTemplates() == null) ? 0 : getReviewTemplates().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListReviewTemplatesResult clone() {
        try {
            return (ListReviewTemplatesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
