/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workdocs.model.PermissionInfo;
import com.amazonaws.services.workdocs.model.PrincipalType;
import com.amazonaws.services.workdocs.model.transform.PrincipalMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Principal
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String type;
    private List<PermissionInfo> roles;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Principal withId(String id) {
        this.setId(id);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Principal withType(String type) {
        this.setType(type);
        return this;
    }

    @JsonIgnore
    public void setType(PrincipalType type) {
        this.type = type.toString();
    }

    public Principal withType(PrincipalType type) {
        this.setType(type);
        return this;
    }

    public List<PermissionInfo> getRoles() {
        return this.roles;
    }

    public void setRoles(Collection<PermissionInfo> roles) {
        if (roles == null) {
            this.roles = null;
            return;
        }
        this.roles = new ArrayList<PermissionInfo>(roles);
    }

    public Principal withRoles(PermissionInfo ... roles) {
        if (this.roles == null) {
            this.setRoles(new ArrayList<PermissionInfo>(roles.length));
        }
        for (PermissionInfo ele : roles) {
            this.roles.add(ele);
        }
        return this;
    }

    public Principal withRoles(Collection<PermissionInfo> roles) {
        this.setRoles(roles);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getRoles() != null) {
            sb.append("Roles: ").append(this.getRoles());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Principal)) {
            return false;
        }
        Principal other = (Principal)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getRoles() == null ^ this.getRoles() == null) {
            return false;
        }
        return other.getRoles() == null || other.getRoles().equals(this.getRoles());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getRoles() == null ? 0 : this.getRoles().hashCode());
        return hashCode;
    }

    public Principal clone() {
        try {
            return (Principal)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PrincipalMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

