/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.workdocs.model.DocumentMetadata;
import com.amazonaws.services.workdocs.model.FolderMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeFolderContentsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<FolderMetadata> folders;
    private List<DocumentMetadata> documents;
    private String marker;

    public List<FolderMetadata> getFolders() {
        return this.folders;
    }

    public void setFolders(Collection<FolderMetadata> folders) {
        if (folders == null) {
            this.folders = null;
            return;
        }
        this.folders = new ArrayList<FolderMetadata>(folders);
    }

    public DescribeFolderContentsResult withFolders(FolderMetadata ... folders) {
        if (this.folders == null) {
            this.setFolders(new ArrayList<FolderMetadata>(folders.length));
        }
        for (FolderMetadata ele : folders) {
            this.folders.add(ele);
        }
        return this;
    }

    public DescribeFolderContentsResult withFolders(Collection<FolderMetadata> folders) {
        this.setFolders(folders);
        return this;
    }

    public List<DocumentMetadata> getDocuments() {
        return this.documents;
    }

    public void setDocuments(Collection<DocumentMetadata> documents) {
        if (documents == null) {
            this.documents = null;
            return;
        }
        this.documents = new ArrayList<DocumentMetadata>(documents);
    }

    public DescribeFolderContentsResult withDocuments(DocumentMetadata ... documents) {
        if (this.documents == null) {
            this.setDocuments(new ArrayList<DocumentMetadata>(documents.length));
        }
        for (DocumentMetadata ele : documents) {
            this.documents.add(ele);
        }
        return this;
    }

    public DescribeFolderContentsResult withDocuments(Collection<DocumentMetadata> documents) {
        this.setDocuments(documents);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeFolderContentsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFolders() != null) {
            sb.append("Folders: ").append(this.getFolders()).append(",");
        }
        if (this.getDocuments() != null) {
            sb.append("Documents: ").append(this.getDocuments()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFolderContentsResult)) {
            return false;
        }
        DescribeFolderContentsResult other = (DescribeFolderContentsResult)obj;
        if (other.getFolders() == null ^ this.getFolders() == null) {
            return false;
        }
        if (other.getFolders() != null && !other.getFolders().equals(this.getFolders())) {
            return false;
        }
        if (other.getDocuments() == null ^ this.getDocuments() == null) {
            return false;
        }
        if (other.getDocuments() != null && !other.getDocuments().equals(this.getDocuments())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFolders() == null ? 0 : this.getFolders().hashCode());
        hashCode = 31 * hashCode + (this.getDocuments() == null ? 0 : this.getDocuments().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public DescribeFolderContentsResult clone() {
        try {
            return (DescribeFolderContentsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

