/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workspaces.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes the user capacity for a pool of WorkSpaces.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/Capacity" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Capacity implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The desired number of user sessions for a multi-session pool. This is not allowed for single-session pools.
     * </p>
     */
    private Integer desiredUserSessions;

    /**
     * <p>
     * The desired number of user sessions for a multi-session pool. This is not allowed for single-session pools.
     * </p>
     * 
     * @param desiredUserSessions
     *        The desired number of user sessions for a multi-session pool. This is not allowed for single-session
     *        pools.
     */

    public void setDesiredUserSessions(Integer desiredUserSessions) {
        this.desiredUserSessions = desiredUserSessions;
    }

    /**
     * <p>
     * The desired number of user sessions for a multi-session pool. This is not allowed for single-session pools.
     * </p>
     * 
     * @return The desired number of user sessions for a multi-session pool. This is not allowed for single-session
     *         pools.
     */

    public Integer getDesiredUserSessions() {
        return this.desiredUserSessions;
    }

    /**
     * <p>
     * The desired number of user sessions for a multi-session pool. This is not allowed for single-session pools.
     * </p>
     * 
     * @param desiredUserSessions
     *        The desired number of user sessions for a multi-session pool. This is not allowed for single-session
     *        pools.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Capacity withDesiredUserSessions(Integer desiredUserSessions) {
        setDesiredUserSessions(desiredUserSessions);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDesiredUserSessions() != null)
            sb.append("DesiredUserSessions: ").append(getDesiredUserSessions());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Capacity == false)
            return false;
        Capacity other = (Capacity) obj;
        if (other.getDesiredUserSessions() == null ^ this.getDesiredUserSessions() == null)
            return false;
        if (other.getDesiredUserSessions() != null && other.getDesiredUserSessions().equals(this.getDesiredUserSessions()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDesiredUserSessions() == null) ? 0 : getDesiredUserSessions().hashCode());
        return hashCode;
    }

    @Override
    public Capacity clone() {
        try {
            return (Capacity) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.workspaces.model.transform.CapacityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
