/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.DhcpConfiguration;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DhcpConfigurationUnmarshaller
implements Unmarshaller<DhcpConfiguration, Node> {
    @Override
    public DhcpConfiguration unmarshall(Node node) throws Exception {
        DhcpConfiguration dhcpConfiguration = new DhcpConfiguration();
        Node keyNode = XpathUtils.asNode("key", node);
        dhcpConfiguration.setKey(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(keyNode));
        NodeList valuesNodes = XpathUtils.asNodeList("valueSet/item", node);
        for (int valuesIndex = 0; valuesIndex < XpathUtils.nodeLength(valuesNodes); ++valuesIndex) {
            Node valuesNode = valuesNodes.item(valuesIndex);
            dhcpConfiguration.getValues().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(valuesNode));
            valuesNode.getParentNode().removeChild(valuesNode);
        }
        return dhcpConfiguration;
    }
}

