/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.autoscaling.AmazonAutoScalingAsync;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.CreateOrUpdateScalingTriggerRequest;
import com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeleteTriggerRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsResult;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesResult;
import com.amazonaws.services.autoscaling.model.DescribeTriggersRequest;
import com.amazonaws.services.autoscaling.model.DescribeTriggersResult;
import com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest;
import com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResult;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonAutoScalingAsyncClient
extends AmazonAutoScalingClient
implements AmazonAutoScalingAsync {
    private ExecutorService executorService;

    public AmazonAutoScalingAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonAutoScalingAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonAutoScalingAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<Void> deleteLaunchConfigurationAsync(final DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deleteLaunchConfiguration(deleteLaunchConfigurationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeTriggersResult> describeTriggersAsync(final DescribeTriggersRequest describeTriggersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeTriggersResult>(){

            @Override
            public DescribeTriggersResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeTriggers(describeTriggersRequest);
            }
        });
    }

    @Override
    public Future<Void> updateAutoScalingGroupAsync(final UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.updateAutoScalingGroup(updateAutoScalingGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createAutoScalingGroupAsync(final CreateAutoScalingGroupRequest createAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.createAutoScalingGroup(createAutoScalingGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteTriggerAsync(final DeleteTriggerRequest deleteTriggerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deleteTrigger(deleteTriggerRequest);
                return null;
            }
        });
    }

    @Override
    public Future<TerminateInstanceInAutoScalingGroupResult> terminateInstanceInAutoScalingGroupAsync(final TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<TerminateInstanceInAutoScalingGroupResult>(){

            @Override
            public TerminateInstanceInAutoScalingGroupResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.terminateInstanceInAutoScalingGroup(terminateInstanceInAutoScalingGroupRequest);
            }
        });
    }

    @Override
    public Future<Void> createOrUpdateScalingTriggerAsync(final CreateOrUpdateScalingTriggerRequest createOrUpdateScalingTriggerRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.createOrUpdateScalingTrigger(createOrUpdateScalingTriggerRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeAutoScalingGroupsResult> describeAutoScalingGroupsAsync(final DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAutoScalingGroupsResult>(){

            @Override
            public DescribeAutoScalingGroupsResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeAutoScalingGroups(describeAutoScalingGroupsRequest);
            }
        });
    }

    @Override
    public Future<Void> createLaunchConfigurationAsync(final CreateLaunchConfigurationRequest createLaunchConfigurationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.createLaunchConfiguration(createLaunchConfigurationRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeLaunchConfigurationsResult> describeLaunchConfigurationsAsync(final DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeLaunchConfigurationsResult>(){

            @Override
            public DescribeLaunchConfigurationsResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeLaunchConfigurations(describeLaunchConfigurationsRequest);
            }
        });
    }

    @Override
    public Future<DescribeScalingActivitiesResult> describeScalingActivitiesAsync(final DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeScalingActivitiesResult>(){

            @Override
            public DescribeScalingActivitiesResult call() throws Exception {
                return AmazonAutoScalingAsyncClient.this.describeScalingActivities(describeScalingActivitiesRequest);
            }
        });
    }

    @Override
    public Future<Void> setDesiredCapacityAsync(final SetDesiredCapacityRequest setDesiredCapacityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.setDesiredCapacity(setDesiredCapacityRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAutoScalingGroupAsync(final DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonAutoScalingAsyncClient.this.deleteAutoScalingGroup(deleteAutoScalingGroupRequest);
                return null;
            }
        });
    }
}

