/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.transform.DimensionUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMetricStatisticsRequestUnmarshaller
implements Unmarshaller<GetMetricStatisticsRequest, Node> {
    @Override
    public GetMetricStatisticsRequest unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        GetMetricStatisticsRequest getMetricStatisticsRequest = new GetMetricStatisticsRequest();
        NodeList statisticsNodes = XpathUtils.asNodeList("Statistics/member", node);
        for (int statisticsIndex = 0; statisticsIndex < XpathUtils.nodeLength(statisticsNodes); ++statisticsIndex) {
            Node statisticsNode = statisticsNodes.item(statisticsIndex);
            getMetricStatisticsRequest.getStatistics().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(statisticsNode));
            statisticsNode.getParentNode().removeChild(statisticsNode);
        }
        Node periodNode = XpathUtils.asNode("Period", node);
        getMetricStatisticsRequest.setPeriod(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(periodNode));
        Node measureNameNode = XpathUtils.asNode("MeasureName", node);
        getMetricStatisticsRequest.setMeasureName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(measureNameNode));
        NodeList dimensionsNodes = XpathUtils.asNodeList("Dimensions/member", node);
        for (int dimensionsIndex = 0; dimensionsIndex < XpathUtils.nodeLength(dimensionsNodes); ++dimensionsIndex) {
            Node dimensionsNode = dimensionsNodes.item(dimensionsIndex);
            getMetricStatisticsRequest.getDimensions().add(new DimensionUnmarshaller().unmarshall(dimensionsNode));
            dimensionsNode.getParentNode().removeChild(dimensionsNode);
        }
        Node startTimeNode = XpathUtils.asNode("StartTime", node);
        getMetricStatisticsRequest.setStartTime(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(startTimeNode));
        Node endTimeNode = XpathUtils.asNode("EndTime", node);
        getMetricStatisticsRequest.setEndTime(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(endTimeNode));
        Node unitNode = XpathUtils.asNode("Unit", node);
        getMetricStatisticsRequest.setUnit(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(unitNode));
        Node customUnitNode = XpathUtils.asNode("CustomUnit", node);
        getMetricStatisticsRequest.setCustomUnit(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(customUnitNode));
        Node namespaceNode = XpathUtils.asNode("Namespace", node);
        getMetricStatisticsRequest.setNamespace(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(namespaceNode));
        return getMetricStatisticsRequest;
    }
}

