/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.BundleInstanceRequest;
import com.amazonaws.services.ec2.model.S3Storage;
import com.amazonaws.services.ec2.model.Storage;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleInstanceRequestMarshaller
implements Marshaller<Request<BundleInstanceRequest>, BundleInstanceRequest> {
    @Override
    public Request<BundleInstanceRequest> marshall(BundleInstanceRequest bundleInstanceRequest) {
        Storage storage;
        DefaultRequest<BundleInstanceRequest> request = new DefaultRequest<BundleInstanceRequest>(bundleInstanceRequest, "AmazonEC2");
        request.addParameter("Action", "BundleInstance");
        request.addParameter("Version", "2009-10-31");
        if (bundleInstanceRequest != null && bundleInstanceRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(bundleInstanceRequest.getInstanceId()));
        }
        if (bundleInstanceRequest != null && (storage = bundleInstanceRequest.getStorage()) != null) {
            S3Storage s3 = storage.getS3();
            if (s3 != null && s3.getBucket() != null) {
                request.addParameter("Storage.S3.Bucket", StringUtils.fromString(s3.getBucket()));
            }
            if (s3 != null && s3.getPrefix() != null) {
                request.addParameter("Storage.S3.Prefix", StringUtils.fromString(s3.getPrefix()));
            }
            if (s3 != null && s3.getAWSAccessKeyId() != null) {
                request.addParameter("Storage.S3.AWSAccessKeyId", StringUtils.fromString(s3.getAWSAccessKeyId()));
            }
            if (s3 != null && s3.getUploadPolicy() != null) {
                request.addParameter("Storage.S3.UploadPolicy", StringUtils.fromString(s3.getUploadPolicy()));
            }
            if (s3 != null && s3.getUploadPolicySignature() != null) {
                request.addParameter("Storage.S3.UploadPolicySignature", StringUtils.fromString(s3.getUploadPolicySignature()));
            }
        }
        return request;
    }
}

