/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.transform.BlockDeviceMappingUnmarshaller;
import com.amazonaws.services.ec2.model.transform.PlacementUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunInstancesRequestUnmarshaller
implements Unmarshaller<RunInstancesRequest, Node> {
    @Override
    public RunInstancesRequest unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest();
        Node imageIdNode = XpathUtils.asNode("ImageId", node);
        runInstancesRequest.setImageId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(imageIdNode));
        Node minCountNode = XpathUtils.asNode("MinCount", node);
        runInstancesRequest.setMinCount(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(minCountNode));
        Node maxCountNode = XpathUtils.asNode("MaxCount", node);
        runInstancesRequest.setMaxCount(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(maxCountNode));
        Node keyNameNode = XpathUtils.asNode("KeyName", node);
        runInstancesRequest.setKeyName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(keyNameNode));
        NodeList securityGroupsNodes = XpathUtils.asNodeList("SecurityGroup/SecurityGroup", node);
        for (int securityGroupsIndex = 0; securityGroupsIndex < XpathUtils.nodeLength(securityGroupsNodes); ++securityGroupsIndex) {
            Node securityGroupsNode = securityGroupsNodes.item(securityGroupsIndex);
            runInstancesRequest.getSecurityGroups().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(securityGroupsNode));
            securityGroupsNode.getParentNode().removeChild(securityGroupsNode);
        }
        Node userDataNode = XpathUtils.asNode("UserData", node);
        runInstancesRequest.setUserData(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(userDataNode));
        Node instanceTypeNode = XpathUtils.asNode("InstanceType", node);
        runInstancesRequest.setInstanceType(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(instanceTypeNode));
        Node placementNode = XpathUtils.asNode("Placement", node);
        runInstancesRequest.setPlacement(new PlacementUnmarshaller().unmarshall(placementNode));
        Node kernelIdNode = XpathUtils.asNode("KernelId", node);
        runInstancesRequest.setKernelId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(kernelIdNode));
        Node ramdiskIdNode = XpathUtils.asNode("RamdiskId", node);
        runInstancesRequest.setRamdiskId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ramdiskIdNode));
        NodeList blockDeviceMappingsNodes = XpathUtils.asNodeList("BlockDeviceMapping/BlockDeviceMapping", node);
        for (int blockDeviceMappingsIndex = 0; blockDeviceMappingsIndex < XpathUtils.nodeLength(blockDeviceMappingsNodes); ++blockDeviceMappingsIndex) {
            Node blockDeviceMappingsNode = blockDeviceMappingsNodes.item(blockDeviceMappingsIndex);
            runInstancesRequest.getBlockDeviceMappings().add(new BlockDeviceMappingUnmarshaller().unmarshall(blockDeviceMappingsNode));
            blockDeviceMappingsNode.getParentNode().removeChild(blockDeviceMappingsNode);
        }
        Node monitoringNode = XpathUtils.asNode("Monitoring", node);
        runInstancesRequest.setMonitoring(new SimpleTypeUnmarshallers.BooleanUnmarshaller().unmarshall(monitoringNode));
        Node subnetIdNode = XpathUtils.asNode("SubnetId", node);
        runInstancesRequest.setSubnetId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(subnetIdNode));
        Node disableApiTerminationNode = XpathUtils.asNode("disableApiTermination", node);
        runInstancesRequest.setDisableApiTermination(new SimpleTypeUnmarshallers.BooleanUnmarshaller().unmarshall(disableApiTerminationNode));
        Node instanceInitiatedShutdownBehaviorNode = XpathUtils.asNode("instanceInitiatedShutdownBehavior", node);
        runInstancesRequest.setInstanceInitiatedShutdownBehavior(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(instanceInitiatedShutdownBehaviorNode));
        return runInstancesRequest;
    }
}

