/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.ModifyDBInstanceRequest;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDBInstanceRequestUnmarshaller
implements Unmarshaller<ModifyDBInstanceRequest, Node> {
    @Override
    public ModifyDBInstanceRequest unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        ModifyDBInstanceRequest modifyDBInstanceRequest = new ModifyDBInstanceRequest();
        Node dBInstanceIdentifierNode = XpathUtils.asNode("DBInstanceIdentifier", node);
        modifyDBInstanceRequest.setDBInstanceIdentifier(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBInstanceIdentifierNode));
        Node allocatedStorageNode = XpathUtils.asNode("AllocatedStorage", node);
        modifyDBInstanceRequest.setAllocatedStorage(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(allocatedStorageNode));
        Node dBInstanceClassNode = XpathUtils.asNode("DBInstanceClass", node);
        modifyDBInstanceRequest.setDBInstanceClass(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBInstanceClassNode));
        NodeList dBSecurityGroupsNodes = XpathUtils.asNodeList("DBSecurityGroups/DBSecurityGroupName", node);
        for (int dBSecurityGroupsIndex = 0; dBSecurityGroupsIndex < XpathUtils.nodeLength(dBSecurityGroupsNodes); ++dBSecurityGroupsIndex) {
            Node dBSecurityGroupsNode = dBSecurityGroupsNodes.item(dBSecurityGroupsIndex);
            modifyDBInstanceRequest.getDBSecurityGroups().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBSecurityGroupsNode));
            dBSecurityGroupsNode.getParentNode().removeChild(dBSecurityGroupsNode);
        }
        Node applyImmediatelyNode = XpathUtils.asNode("ApplyImmediately", node);
        modifyDBInstanceRequest.setApplyImmediately(new SimpleTypeUnmarshallers.BooleanUnmarshaller().unmarshall(applyImmediatelyNode));
        Node masterUserPasswordNode = XpathUtils.asNode("MasterUserPassword", node);
        modifyDBInstanceRequest.setMasterUserPassword(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(masterUserPasswordNode));
        Node dBParameterGroupNameNode = XpathUtils.asNode("DBParameterGroupName", node);
        modifyDBInstanceRequest.setDBParameterGroupName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBParameterGroupNameNode));
        Node backupRetentionPeriodNode = XpathUtils.asNode("BackupRetentionPeriod", node);
        modifyDBInstanceRequest.setBackupRetentionPeriod(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(backupRetentionPeriodNode));
        Node preferredBackupWindowNode = XpathUtils.asNode("PreferredBackupWindow", node);
        modifyDBInstanceRequest.setPreferredBackupWindow(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(preferredBackupWindowNode));
        Node preferredMaintenanceWindowNode = XpathUtils.asNode("PreferredMaintenanceWindow", node);
        modifyDBInstanceRequest.setPreferredMaintenanceWindow(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(preferredMaintenanceWindowNode));
        return modifyDBInstanceRequest;
    }
}

