/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.services.sns.model.AddPermissionRequest;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPermissionRequestUnmarshaller
implements Unmarshaller<AddPermissionRequest, Node> {
    @Override
    public AddPermissionRequest unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        AddPermissionRequest addPermissionRequest = new AddPermissionRequest();
        Node topicArnNode = XpathUtils.asNode("TopicArn", node);
        addPermissionRequest.setTopicArn(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(topicArnNode));
        Node labelNode = XpathUtils.asNode("Label", node);
        addPermissionRequest.setLabel(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(labelNode));
        NodeList aWSAccountIdsNodes = XpathUtils.asNodeList("AWSAccountId/member", node);
        for (int aWSAccountIdsIndex = 0; aWSAccountIdsIndex < XpathUtils.nodeLength(aWSAccountIdsNodes); ++aWSAccountIdsIndex) {
            Node aWSAccountIdsNode = aWSAccountIdsNodes.item(aWSAccountIdsIndex);
            addPermissionRequest.getAWSAccountIds().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(aWSAccountIdsNode));
            aWSAccountIdsNode.getParentNode().removeChild(aWSAccountIdsNode);
        }
        NodeList actionNamesNodes = XpathUtils.asNodeList("ActionName/member", node);
        for (int actionNamesIndex = 0; actionNamesIndex < XpathUtils.nodeLength(actionNamesNodes); ++actionNamesIndex) {
            Node actionNamesNode = actionNamesNodes.item(actionNamesIndex);
            addPermissionRequest.getActionNames().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(actionNamesNode));
            actionNamesNode.getParentNode().removeChild(actionNamesNode);
        }
        return addPermissionRequest;
    }
}

