/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.transform.InstanceUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoScalingGroupUnmarshaller
implements Unmarshaller<AutoScalingGroup, Node> {
    @Override
    public AutoScalingGroup unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        AutoScalingGroup autoScalingGroup = new AutoScalingGroup();
        Node autoScalingGroupNameNode = XpathUtils.asNode("AutoScalingGroupName", node);
        autoScalingGroup.setAutoScalingGroupName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(autoScalingGroupNameNode));
        Node launchConfigurationNameNode = XpathUtils.asNode("LaunchConfigurationName", node);
        autoScalingGroup.setLaunchConfigurationName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(launchConfigurationNameNode));
        Node minSizeNode = XpathUtils.asNode("MinSize", node);
        autoScalingGroup.setMinSize(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(minSizeNode));
        Node maxSizeNode = XpathUtils.asNode("MaxSize", node);
        autoScalingGroup.setMaxSize(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(maxSizeNode));
        Node desiredCapacityNode = XpathUtils.asNode("DesiredCapacity", node);
        autoScalingGroup.setDesiredCapacity(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(desiredCapacityNode));
        Node cooldownNode = XpathUtils.asNode("Cooldown", node);
        autoScalingGroup.setCooldown(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(cooldownNode));
        NodeList availabilityZonesNodes = XpathUtils.asNodeList("AvailabilityZones/member", node);
        for (int availabilityZonesIndex = 0; availabilityZonesIndex < XpathUtils.nodeLength(availabilityZonesNodes); ++availabilityZonesIndex) {
            Node availabilityZonesNode = availabilityZonesNodes.item(availabilityZonesIndex);
            autoScalingGroup.getAvailabilityZones().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(availabilityZonesNode));
            availabilityZonesNode.getParentNode().removeChild(availabilityZonesNode);
        }
        NodeList loadBalancerNamesNodes = XpathUtils.asNodeList("LoadBalancerNames/member", node);
        for (int loadBalancerNamesIndex = 0; loadBalancerNamesIndex < XpathUtils.nodeLength(loadBalancerNamesNodes); ++loadBalancerNamesIndex) {
            Node loadBalancerNamesNode = loadBalancerNamesNodes.item(loadBalancerNamesIndex);
            autoScalingGroup.getLoadBalancerNames().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(loadBalancerNamesNode));
            loadBalancerNamesNode.getParentNode().removeChild(loadBalancerNamesNode);
        }
        NodeList instancesNodes = XpathUtils.asNodeList("Instances/member", node);
        for (int instancesIndex = 0; instancesIndex < XpathUtils.nodeLength(instancesNodes); ++instancesIndex) {
            Node instancesNode = instancesNodes.item(instancesIndex);
            autoScalingGroup.getInstances().add(new InstanceUnmarshaller().unmarshall(instancesNode));
            instancesNode.getParentNode().removeChild(instancesNode);
        }
        Node createdTimeNode = XpathUtils.asNode("CreatedTime", node);
        autoScalingGroup.setCreatedTime(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(createdTimeNode));
        return autoScalingGroup;
    }
}

