/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.transform.BlockDeviceMappingUnmarshaller;
import com.amazonaws.services.ec2.model.transform.PlacementUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchSpecificationUnmarshaller
implements Unmarshaller<LaunchSpecification, Node> {
    @Override
    public LaunchSpecification unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        LaunchSpecification launchSpecification = new LaunchSpecification();
        Node imageIdNode = XpathUtils.asNode("imageId", node);
        launchSpecification.setImageId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(imageIdNode));
        Node keyNameNode = XpathUtils.asNode("keyName", node);
        launchSpecification.setKeyName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(keyNameNode));
        NodeList securityGroupsNodes = XpathUtils.asNodeList("groupSet/item/groupId", node);
        for (int securityGroupsIndex = 0; securityGroupsIndex < XpathUtils.nodeLength(securityGroupsNodes); ++securityGroupsIndex) {
            Node securityGroupsNode = securityGroupsNodes.item(securityGroupsIndex);
            launchSpecification.getSecurityGroups().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(securityGroupsNode));
            securityGroupsNode.getParentNode().removeChild(securityGroupsNode);
        }
        Node userDataNode = XpathUtils.asNode("userData", node);
        launchSpecification.setUserData(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(userDataNode));
        Node addressingTypeNode = XpathUtils.asNode("addressingType", node);
        launchSpecification.setAddressingType(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(addressingTypeNode));
        Node instanceTypeNode = XpathUtils.asNode("instanceType", node);
        launchSpecification.setInstanceType(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(instanceTypeNode));
        Node placementNode = XpathUtils.asNode("placement", node);
        launchSpecification.setPlacement(new PlacementUnmarshaller().unmarshall(placementNode));
        Node kernelIdNode = XpathUtils.asNode("kernelId", node);
        launchSpecification.setKernelId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(kernelIdNode));
        Node ramdiskIdNode = XpathUtils.asNode("ramdiskId", node);
        launchSpecification.setRamdiskId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ramdiskIdNode));
        NodeList blockDeviceMappingsNodes = XpathUtils.asNodeList("blockDeviceMapping/item", node);
        for (int blockDeviceMappingsIndex = 0; blockDeviceMappingsIndex < XpathUtils.nodeLength(blockDeviceMappingsNodes); ++blockDeviceMappingsIndex) {
            Node blockDeviceMappingsNode = blockDeviceMappingsNodes.item(blockDeviceMappingsIndex);
            launchSpecification.getBlockDeviceMappings().add(new BlockDeviceMappingUnmarshaller().unmarshall(blockDeviceMappingsNode));
            blockDeviceMappingsNode.getParentNode().removeChild(blockDeviceMappingsNode);
        }
        Node monitoringEnabledNode = XpathUtils.asNode("monitoring/enabled", node);
        launchSpecification.setMonitoringEnabled(new SimpleTypeUnmarshallers.BooleanUnmarshaller().unmarshall(monitoringEnabledNode));
        Node subnetIdNode = XpathUtils.asNode("subnetId", node);
        launchSpecification.setSubnetId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(subnetIdNode));
        return launchSpecification;
    }
}

