/*
 * Copyright 2010 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.ec2.model.transform;

import org.w3c.dom.*;
import com.amazonaws.services.ec2.model.*;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers.*;
import com.amazonaws.util.XpathUtils;

/**
 * Describe Key Pairs Result Unmarshaller
 */
public class DescribeKeyPairsResultUnmarshaller implements Unmarshaller<DescribeKeyPairsResult, Node> {

    public DescribeKeyPairsResult unmarshall(Node node) throws Exception {
        if (node == null) return null;

        DescribeKeyPairsResult describeKeyPairsResult = new DescribeKeyPairsResult();

        
        NodeList keyPairsNodes = XpathUtils.asNodeList("keySet/item", node);
        for (int keyPairsIndex = 0; keyPairsIndex < XpathUtils.nodeLength(keyPairsNodes); ++keyPairsIndex) {
            Node keyPairsNode = keyPairsNodes.item(keyPairsIndex);
            describeKeyPairsResult.getKeyPairs().add(new KeyPairInfoUnmarshaller().unmarshall(keyPairsNode));
            keyPairsNode.getParentNode().removeChild(keyPairsNode);
        }
    

        return describeKeyPairsResult;
    }
}
    