/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.ImageAttribute;
import com.amazonaws.services.ec2.model.transform.BlockDeviceMappingUnmarshaller;
import com.amazonaws.services.ec2.model.transform.LaunchPermissionUnmarshaller;
import com.amazonaws.services.ec2.model.transform.ProductCodeUnmarshaller;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageAttributeUnmarshaller
implements Unmarshaller<ImageAttribute, Node> {
    @Override
    public ImageAttribute unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        ImageAttribute imageAttribute = new ImageAttribute();
        Node imageIdNode = XpathUtils.asNode("imageId", node);
        imageAttribute.setImageId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(imageIdNode));
        NodeList launchPermissionsNodes = XpathUtils.asNodeList("launchPermission/item", node);
        for (int launchPermissionsIndex = 0; launchPermissionsIndex < XpathUtils.nodeLength(launchPermissionsNodes); ++launchPermissionsIndex) {
            Node launchPermissionsNode = launchPermissionsNodes.item(launchPermissionsIndex);
            imageAttribute.getLaunchPermissions().add(new LaunchPermissionUnmarshaller().unmarshall(launchPermissionsNode));
            launchPermissionsNode.getParentNode().removeChild(launchPermissionsNode);
        }
        NodeList productCodesNodes = XpathUtils.asNodeList("productCodes/item", node);
        for (int productCodesIndex = 0; productCodesIndex < XpathUtils.nodeLength(productCodesNodes); ++productCodesIndex) {
            Node productCodesNode = productCodesNodes.item(productCodesIndex);
            imageAttribute.getProductCodes().add(new ProductCodeUnmarshaller().unmarshall(productCodesNode));
            productCodesNode.getParentNode().removeChild(productCodesNode);
        }
        Node kernelIdNode = XpathUtils.asNode("kernel/value", node);
        imageAttribute.setKernelId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(kernelIdNode));
        Node ramdiskIdNode = XpathUtils.asNode("ramdisk/value", node);
        imageAttribute.setRamdiskId(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(ramdiskIdNode));
        Node descriptionNode = XpathUtils.asNode("description/value", node);
        imageAttribute.setDescription(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(descriptionNode));
        NodeList blockDeviceMappingsNodes = XpathUtils.asNodeList("blockDeviceMapping/item", node);
        for (int blockDeviceMappingsIndex = 0; blockDeviceMappingsIndex < XpathUtils.nodeLength(blockDeviceMappingsNodes); ++blockDeviceMappingsIndex) {
            Node blockDeviceMappingsNode = blockDeviceMappingsNodes.item(blockDeviceMappingsIndex);
            imageAttribute.getBlockDeviceMappings().add(new BlockDeviceMappingUnmarshaller().unmarshall(blockDeviceMappingsNode));
            blockDeviceMappingsNode.getParentNode().removeChild(blockDeviceMappingsNode);
        }
        return imageAttribute;
    }
}

