/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishRequestStaxUnmarshaller
implements Unmarshaller<PublishRequest, StaxUnmarshallerContext> {
    private static PublishRequestStaxUnmarshaller instance;

    @Override
    public PublishRequest unmarshall(StaxUnmarshallerContext context) throws Exception {
        PublishRequest publishRequest = new PublishRequest();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent event;
            if ((event = context.nextEvent()).isEndDocument()) {
                return publishRequest;
            }
            if (event.isAttribute() || event.isStartElement()) {
                if (context.testExpression("TopicArn", targetDepth)) {
                    publishRequest.setTopicArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Message", targetDepth)) {
                    publishRequest.setMessage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Subject", targetDepth)) continue;
                publishRequest.setSubject(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (event.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return publishRequest;
    }

    public static PublishRequestStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PublishRequestStaxUnmarshaller();
        }
        return instance;
    }
}

