/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyInstanceAttributeRequest
extends AmazonWebServiceRequest {
    private String instanceId;
    private String attribute;
    private String value;
    private List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings;
    private Boolean sourceDestCheck;
    private List<String> groups;

    public ModifyInstanceAttributeRequest() {
    }

    public ModifyInstanceAttributeRequest(String instanceId, String attribute) {
        this.instanceId = instanceId;
        this.attribute = attribute;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public ModifyInstanceAttributeRequest withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public ModifyInstanceAttributeRequest withAttribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ModifyInstanceAttributeRequest withValue(String value) {
        this.value = value;
        return this;
    }

    public List<InstanceBlockDeviceMappingSpecification> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<InstanceBlockDeviceMappingSpecification>();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
        ArrayList<InstanceBlockDeviceMappingSpecification> blockDeviceMappingsCopy = new ArrayList<InstanceBlockDeviceMappingSpecification>();
        if (blockDeviceMappings != null) {
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        }
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public ModifyInstanceAttributeRequest withBlockDeviceMappings(InstanceBlockDeviceMappingSpecification ... blockDeviceMappings) {
        for (InstanceBlockDeviceMappingSpecification value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public ModifyInstanceAttributeRequest withBlockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
        ArrayList<InstanceBlockDeviceMappingSpecification> blockDeviceMappingsCopy = new ArrayList<InstanceBlockDeviceMappingSpecification>();
        if (blockDeviceMappings != null) {
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        }
        this.blockDeviceMappings = blockDeviceMappingsCopy;
        return this;
    }

    public Boolean isSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public void setSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
    }

    public ModifyInstanceAttributeRequest withSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
        return this;
    }

    public Boolean getSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public List<String> getGroups() {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        ArrayList<String> groupsCopy = new ArrayList<String>();
        if (groups != null) {
            groupsCopy.addAll(groups);
        }
        this.groups = groupsCopy;
    }

    public ModifyInstanceAttributeRequest withGroups(String ... groups) {
        for (String value : groups) {
            this.getGroups().add(value);
        }
        return this;
    }

    public ModifyInstanceAttributeRequest withGroups(Collection<String> groups) {
        ArrayList<String> groupsCopy = new ArrayList<String>();
        if (groups != null) {
            groupsCopy.addAll(groups);
        }
        this.groups = groupsCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("InstanceId: " + this.instanceId + ", ");
        sb.append("Attribute: " + this.attribute + ", ");
        sb.append("Value: " + this.value + ", ");
        sb.append("BlockDeviceMappings: " + this.blockDeviceMappings + ", ");
        sb.append("SourceDestCheck: " + this.sourceDestCheck + ", ");
        sb.append("Groups: " + this.groups + ", ");
        sb.append("}");
        return sb.toString();
    }
}

