/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendMessageBatchRequest
extends AmazonWebServiceRequest {
    private String queueUrl;
    private List<SendMessageBatchRequestEntry> entries;

    public SendMessageBatchRequest() {
    }

    public SendMessageBatchRequest(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public SendMessageBatchRequest(String queueUrl, List<SendMessageBatchRequestEntry> entries) {
        this.queueUrl = queueUrl;
        this.entries = entries;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public SendMessageBatchRequest withQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
        return this;
    }

    public List<SendMessageBatchRequestEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<SendMessageBatchRequestEntry>();
        }
        return this.entries;
    }

    public void setEntries(Collection<SendMessageBatchRequestEntry> entries) {
        ArrayList<SendMessageBatchRequestEntry> entriesCopy = new ArrayList<SendMessageBatchRequestEntry>();
        if (entries != null) {
            entriesCopy.addAll(entries);
        }
        this.entries = entriesCopy;
    }

    public SendMessageBatchRequest withEntries(SendMessageBatchRequestEntry ... entries) {
        if (this.getEntries() == null) {
            this.setEntries(new ArrayList<SendMessageBatchRequestEntry>());
        }
        for (SendMessageBatchRequestEntry value : entries) {
            this.getEntries().add(value);
        }
        return this;
    }

    public SendMessageBatchRequest withEntries(Collection<SendMessageBatchRequestEntry> entries) {
        ArrayList<SendMessageBatchRequestEntry> entriesCopy = new ArrayList<SendMessageBatchRequestEntry>();
        if (entries != null) {
            entriesCopy.addAll(entries);
        }
        this.entries = entriesCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("QueueUrl: " + this.queueUrl + ", ");
        sb.append("Entries: " + this.entries + ", ");
        sb.append("}");
        return sb.toString();
    }
}

