
/**
 * Synchronous and asynchronous client classes for accessing AmazonCloudFormation.
 *
 * AWS CloudFormation <p>
 * This is the AWS CloudFormation API Reference. The major sections of
 * this guide are described in the following table.
 * </p>
 * 
 * <ul>
 * <li> <a
 * rvices.com/AWSCloudFormation/latest/APIReference/API_Operations.html">
 * Actions </a> : Alphabetical list of CloudFormation actions</li>
 * <li> <a
 * webservices.com/AWSCloudFormation/latest/APIReference/API_Types.html">
 * Data Types </a> : Alphabetical list of CloudFormation data types</li>
 * <li> <a
 * ices.com/AWSCloudFormation/latest/APIReference/CommonParameters.html">
 * Common Parameters </a> : Parameters that all Query actions can
 * use</li>
 * <li> <a
 * services.com/AWSCloudFormation/latest/APIReference/CommonErrors.html">
 * Common Errors </a> : Client and server errors that all actions can
 * return</li>
 * 
 * </ul>
 * <p>
 * This guide is for programmers who need detailed information about the
 * CloudFormation APIs. You use AWS CloudFormation to create and manage
 * AWS infrastructure deployments predictably and repeatedly.
 * CloudFormation helps you leverage AWS products such as Amazon EC2,
 * EBS, Amazon SNS, ELB, and Auto Scaling to build highly-reliable,
 * highly scalable, cost effective applications without worrying about
 * creating and configuring the underlying the AWS infrastructure.
 * </p>
 * <p>
 * Through the use of a template file you write, and a few AWS
 * CloudFormation commands or API actions, AWS CloudFormation enables you
 * to manage a collection of resources together as a single unit called a
 * stack. AWS CloudFormation creates and deletes all member resources of
 * the stack together and manages all dependencies between the resources
 * for you.
 * </p>
 * <p>
 * For more information about this product, go to the <a
 * href="http://aws.amazon.com/cloudformation/"> CloudFormation Product
 * Page </a> .
 * </p>
 * <p>
 * Amazon CloudFormation makes use of other AWS products. If you need
 * additional technical information about a specific AWS product, you can
 * find the product's technical documentation at <a
 * href="http://aws.amazon.com/documentation/">
 * http://aws.amazon.com/documentation/ </a> .
 * </p>
 */
 package com.amazonaws.services.cloudformation;
        