/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.services.cloudformation.model.Output;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.StackStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stack {
    private String stackId;
    private String stackName;
    private String description;
    private List<Parameter> parameters;
    private Date creationTime;
    private Date lastUpdatedTime;
    private String stackStatus;
    private String stackStatusReason;
    private Boolean disableRollback;
    private List<String> notificationARNs;
    private Integer timeoutInMinutes;
    private List<String> capabilities;
    private List<Output> outputs;

    public String getStackId() {
        return this.stackId;
    }

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public Stack withStackId(String stackId) {
        this.stackId = stackId;
        return this;
    }

    public String getStackName() {
        return this.stackName;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public Stack withStackName(String stackName) {
        this.stackName = stackName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Stack withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        ArrayList<Parameter> parametersCopy = new ArrayList<Parameter>();
        if (parameters != null) {
            parametersCopy.addAll(parameters);
        }
        this.parameters = parametersCopy;
    }

    public Stack withParameters(Parameter ... parameters) {
        if (this.getParameters() == null) {
            this.setParameters(new ArrayList<Parameter>());
        }
        for (Parameter value : parameters) {
            this.getParameters().add(value);
        }
        return this;
    }

    public Stack withParameters(Collection<Parameter> parameters) {
        ArrayList<Parameter> parametersCopy = new ArrayList<Parameter>();
        if (parameters != null) {
            parametersCopy.addAll(parameters);
        }
        this.parameters = parametersCopy;
        return this;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Stack withCreationTime(Date creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Stack withLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    public String getStackStatus() {
        return this.stackStatus;
    }

    public void setStackStatus(String stackStatus) {
        this.stackStatus = stackStatus;
    }

    public Stack withStackStatus(String stackStatus) {
        this.stackStatus = stackStatus;
        return this;
    }

    public void setStackStatus(StackStatus stackStatus) {
        this.stackStatus = stackStatus.toString();
    }

    public Stack withStackStatus(StackStatus stackStatus) {
        this.stackStatus = stackStatus.toString();
        return this;
    }

    public String getStackStatusReason() {
        return this.stackStatusReason;
    }

    public void setStackStatusReason(String stackStatusReason) {
        this.stackStatusReason = stackStatusReason;
    }

    public Stack withStackStatusReason(String stackStatusReason) {
        this.stackStatusReason = stackStatusReason;
        return this;
    }

    public Boolean isDisableRollback() {
        return this.disableRollback;
    }

    public void setDisableRollback(Boolean disableRollback) {
        this.disableRollback = disableRollback;
    }

    public Stack withDisableRollback(Boolean disableRollback) {
        this.disableRollback = disableRollback;
        return this;
    }

    public Boolean getDisableRollback() {
        return this.disableRollback;
    }

    public List<String> getNotificationARNs() {
        if (this.notificationARNs == null) {
            this.notificationARNs = new ArrayList<String>();
        }
        return this.notificationARNs;
    }

    public void setNotificationARNs(Collection<String> notificationARNs) {
        ArrayList<String> notificationARNsCopy = new ArrayList<String>();
        if (notificationARNs != null) {
            notificationARNsCopy.addAll(notificationARNs);
        }
        this.notificationARNs = notificationARNsCopy;
    }

    public Stack withNotificationARNs(String ... notificationARNs) {
        if (this.getNotificationARNs() == null) {
            this.setNotificationARNs(new ArrayList<String>());
        }
        for (String value : notificationARNs) {
            this.getNotificationARNs().add(value);
        }
        return this;
    }

    public Stack withNotificationARNs(Collection<String> notificationARNs) {
        ArrayList<String> notificationARNsCopy = new ArrayList<String>();
        if (notificationARNs != null) {
            notificationARNsCopy.addAll(notificationARNs);
        }
        this.notificationARNs = notificationARNsCopy;
        return this;
    }

    public Integer getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public void setTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public Stack withTimeoutInMinutes(Integer timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
        return this;
    }

    public List<String> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        ArrayList<String> capabilitiesCopy = new ArrayList<String>();
        if (capabilities != null) {
            capabilitiesCopy.addAll(capabilities);
        }
        this.capabilities = capabilitiesCopy;
    }

    public Stack withCapabilities(String ... capabilities) {
        if (this.getCapabilities() == null) {
            this.setCapabilities(new ArrayList<String>());
        }
        for (String value : capabilities) {
            this.getCapabilities().add(value);
        }
        return this;
    }

    public Stack withCapabilities(Collection<String> capabilities) {
        ArrayList<String> capabilitiesCopy = new ArrayList<String>();
        if (capabilities != null) {
            capabilitiesCopy.addAll(capabilities);
        }
        this.capabilities = capabilitiesCopy;
        return this;
    }

    public List<Output> getOutputs() {
        if (this.outputs == null) {
            this.outputs = new ArrayList<Output>();
        }
        return this.outputs;
    }

    public void setOutputs(Collection<Output> outputs) {
        ArrayList<Output> outputsCopy = new ArrayList<Output>();
        if (outputs != null) {
            outputsCopy.addAll(outputs);
        }
        this.outputs = outputsCopy;
    }

    public Stack withOutputs(Output ... outputs) {
        if (this.getOutputs() == null) {
            this.setOutputs(new ArrayList<Output>());
        }
        for (Output value : outputs) {
            this.getOutputs().add(value);
        }
        return this;
    }

    public Stack withOutputs(Collection<Output> outputs) {
        ArrayList<Output> outputsCopy = new ArrayList<Output>();
        if (outputs != null) {
            outputsCopy.addAll(outputs);
        }
        this.outputs = outputsCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("StackId: " + this.stackId + ", ");
        sb.append("StackName: " + this.stackName + ", ");
        sb.append("Description: " + this.description + ", ");
        sb.append("Parameters: " + this.parameters + ", ");
        sb.append("CreationTime: " + this.creationTime + ", ");
        sb.append("LastUpdatedTime: " + this.lastUpdatedTime + ", ");
        sb.append("StackStatus: " + this.stackStatus + ", ");
        sb.append("StackStatusReason: " + this.stackStatusReason + ", ");
        sb.append("DisableRollback: " + this.disableRollback + ", ");
        sb.append("NotificationARNs: " + this.notificationARNs + ", ");
        sb.append("TimeoutInMinutes: " + this.timeoutInMinutes + ", ");
        sb.append("Capabilities: " + this.capabilities + ", ");
        sb.append("Outputs: " + this.outputs + ", ");
        sb.append("}");
        return sb.toString();
    }
}

