/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.simpledb.AmazonSimpleDBAsync;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeleteDomainRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.services.simpledb.model.GetAttributesResult;
import com.amazonaws.services.simpledb.model.ListDomainsRequest;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleDBAsyncClient
extends AmazonSimpleDBClient
implements AmazonSimpleDBAsync {
    private ExecutorService executorService;

    public AmazonSimpleDBAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonSimpleDBAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonSimpleDBAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<SelectResult> selectAsync(final SelectRequest selectRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SelectResult>(){

            @Override
            public SelectResult call() throws Exception {
                return AmazonSimpleDBAsyncClient.this.select(selectRequest);
            }
        });
    }

    @Override
    public Future<Void> putAttributesAsync(final PutAttributesRequest putAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.putAttributes(putAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> batchDeleteAttributesAsync(final BatchDeleteAttributesRequest batchDeleteAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.batchDeleteAttributes(batchDeleteAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDomainAsync(final DeleteDomainRequest deleteDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.deleteDomain(deleteDomainRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createDomainAsync(final CreateDomainRequest createDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.createDomain(createDomainRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAttributesAsync(final DeleteAttributesRequest deleteAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.deleteAttributes(deleteAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<ListDomainsResult> listDomainsAsync(final ListDomainsRequest listDomainsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDomainsResult>(){

            @Override
            public ListDomainsResult call() throws Exception {
                return AmazonSimpleDBAsyncClient.this.listDomains(listDomainsRequest);
            }
        });
    }

    @Override
    public Future<GetAttributesResult> getAttributesAsync(final GetAttributesRequest getAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetAttributesResult>(){

            @Override
            public GetAttributesResult call() throws Exception {
                return AmazonSimpleDBAsyncClient.this.getAttributes(getAttributesRequest);
            }
        });
    }

    @Override
    public Future<Void> batchPutAttributesAsync(final BatchPutAttributesRequest batchPutAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.batchPutAttributes(batchPutAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DomainMetadataResult> domainMetadataAsync(final DomainMetadataRequest domainMetadataRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DomainMetadataResult>(){

            @Override
            public DomainMetadataResult call() throws Exception {
                return AmazonSimpleDBAsyncClient.this.domainMetadata(domainMetadataRequest);
            }
        });
    }
}

