
/**
 * Synchronous and asynchronous client classes for accessing AmazonAutoScaling.
 *
 * Auto Scaling <p>
 * Auto Scaling is a web service designed to automatically launch or
 * terminate EC2 instances based on user-defined policies, schedules, and
 * health checks. Auto Scaling responds automatically to changing
 * conditions. All you need to do is specify how it should respond to
 * those changes.
 * </p>
 * <p>
 * Auto Scaling groups can work across multiple Availability Zones -
 * distinct physical locations for the hosted Amazon EC2 instances - so
 * that if an Availability Zone becomes unavailable, Auto Scaling will
 * automatically redistribute applications to a different Availability
 * Zone.
 * </p>
 * <p>
 * Every API call returns a response meta data object that contains a
 * request identifier. Successful requests return an HTTP 200 status
 * code. Unsuccessful requests return an error object and an HTTP status
 * code of 400 or 500.
 * </p>
 * <p>
 * The current WSDL is available at:
 * </p>
 * <p>
 * <a
 * ef="http://autoscaling.amazonaws.com/doc/2010-08-01/AutoScaling.wsdl">
 * http://autoscaling.amazonaws.com/doc/2010-08-01/AutoScaling.wsdl </a>
 * </p>
 * <p>
 * <b>Endpoints</b>
 * </p>
 * <p>
 * Auto Scaling supports the following region-specific endpoints:
 * </p>
 * 
 * <ul>
 * <li>autoscaling.us-east-1.amazonaws.com</li>
 * <li>autoscaling.us-west-1.amazonaws.com</li>
 * <li>autoscaling.eu-west-1.amazonaws.com</li>
 * <li>autoscaling.ap-southeast-1.amazonaws.com</li>
 * 
 * </ul>
 */
 package com.amazonaws.services.autoscaling;
        