/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.ProgressEvent;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.internal.ProgressListenerChain;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.services.s3.transfer.internal.UploadPartCallable;
import com.amazonaws.services.s3.transfer.internal.UploadPartRequestFactory;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadCallable
implements Callable<UploadResult> {
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final PutObjectRequest putObjectRequest;
    private String multipartUploadId;
    private static final Log log = LogFactory.getLog(UploadCallable.class);
    private final TransferManagerConfiguration configuration;
    private final ProgressListenerChain progressListenerChain;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();

    public UploadCallable(TransferManager transferManager, ExecutorService threadPool, PutObjectRequest putObjectRequest, ProgressListenerChain progressListenerChain) {
        this.s3 = transferManager.getAmazonS3Client();
        this.configuration = transferManager.getConfiguration();
        this.threadPool = threadPool;
        this.putObjectRequest = putObjectRequest;
        this.progressListenerChain = progressListenerChain;
    }

    List<Future<PartETag>> getFutures() {
        return this.futures;
    }

    String getMultipartUploadId() {
        return this.multipartUploadId;
    }

    @Override
    public UploadResult call() throws Exception {
        this.fireProgressEvent(1);
        if (TransferManagerUtils.shouldUseMultipartUpload(this.putObjectRequest, this.configuration)) {
            return this.uploadInParts();
        }
        return this.uploadInOneChunk();
    }

    private UploadResult uploadInOneChunk() {
        PutObjectResult putObjectResult = this.s3.putObject(this.putObjectRequest);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(this.putObjectRequest.getBucketName());
        uploadResult.setKey(this.putObjectRequest.getKey());
        uploadResult.setETag(putObjectResult.getETag());
        uploadResult.setVersionId(putObjectResult.getVersionId());
        return uploadResult;
    }

    private UploadResult uploadInParts() throws Exception {
        String bucketName = this.putObjectRequest.getBucketName();
        String key = this.putObjectRequest.getKey();
        boolean isUsingEncryption = this.s3 instanceof AmazonS3EncryptionClient;
        long optimalPartSize = this.getOptimalPartSize(isUsingEncryption);
        this.multipartUploadId = this.initiateMultipartUpload(this.putObjectRequest);
        try {
            UploadPartRequestFactory requestFactory = new UploadPartRequestFactory(this.putObjectRequest, this.multipartUploadId, optimalPartSize);
            if (TransferManagerUtils.isUploadParallelizable(this.putObjectRequest, isUsingEncryption)) {
                this.uploadPartsInParallel(requestFactory);
                UploadResult uploadResult = null;
                return uploadResult;
            }
            UploadResult uploadResult = this.uploadPartsInSeries(requestFactory);
            return uploadResult;
        }
        catch (Exception e) {
            this.fireProgressEvent(4);
            try {
                this.s3.abortMultipartUpload(new AbortMultipartUploadRequest(bucketName, key, this.multipartUploadId));
            }
            catch (Exception e2) {
                log.info((Object)("Unable to abort multipart upload, you may need to manually remove uploaded parts: " + e2.getMessage()), (Throwable)e2);
            }
            throw e;
        }
        finally {
            if (this.putObjectRequest.getInputStream() != null) {
                try {
                    this.putObjectRequest.getInputStream().close();
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to cleanly close input stream: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private long getOptimalPartSize(boolean isUsingEncryption) {
        long optimalPartSize = TransferManagerUtils.calculateOptimalPartSize(this.putObjectRequest, this.configuration);
        if (isUsingEncryption) {
            optimalPartSize += optimalPartSize % 32L;
        }
        log.debug((Object)("Calculated optimal part size: " + optimalPartSize));
        return optimalPartSize;
    }

    private UploadResult uploadPartsInSeries(UploadPartRequestFactory requestFactory) {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        while (requestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            partETags.add(this.s3.uploadPart(requestFactory.getNextUploadPartRequest()).getPartETag());
        }
        CompleteMultipartUploadResult completeMultipartUploadResult = this.s3.completeMultipartUpload(new CompleteMultipartUploadRequest(this.putObjectRequest.getBucketName(), this.putObjectRequest.getKey(), this.multipartUploadId, partETags));
        this.fireProgressEvent(2);
        UploadResult uploadResult = new UploadResult();
        uploadResult.setBucketName(completeMultipartUploadResult.getBucketName());
        uploadResult.setKey(completeMultipartUploadResult.getKey());
        uploadResult.setETag(completeMultipartUploadResult.getETag());
        uploadResult.setVersionId(completeMultipartUploadResult.getVersionId());
        return uploadResult;
    }

    private void uploadPartsInParallel(UploadPartRequestFactory requestFactory) {
        while (requestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            UploadPartRequest request = requestFactory.getNextUploadPartRequest();
            this.futures.add(this.threadPool.submit(new UploadPartCallable(this.s3, request)));
        }
    }

    private String initiateMultipartUpload(PutObjectRequest putObjectRequest) {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(putObjectRequest.getBucketName(), putObjectRequest.getKey()).withCannedACL(putObjectRequest.getCannedAcl()).withObjectMetadata(putObjectRequest.getMetadata());
        if (putObjectRequest.getStorageClass() != null) {
            initiateMultipartUploadRequest.setStorageClass(StorageClass.fromValue(putObjectRequest.getStorageClass()));
        }
        String uploadId = this.s3.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
        log.debug((Object)("Initiated new multipart upload: " + uploadId));
        return uploadId;
    }

    private void fireProgressEvent(int eventType) {
        if (this.progressListenerChain == null) {
            return;
        }
        ProgressEvent event = new ProgressEvent(0);
        event.setEventCode(eventType);
        this.progressListenerChain.progressChanged(event);
    }
}

