/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.HypervisorType;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceLicense;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.Monitoring;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.ProductCode;
import com.amazonaws.services.ec2.model.StateReason;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.VirtualizationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instance {
    private String instanceId;
    private String imageId;
    private InstanceState state;
    private String privateDnsName;
    private String publicDnsName;
    private String stateTransitionReason;
    private String keyName;
    private Integer amiLaunchIndex;
    private List<ProductCode> productCodes;
    private String instanceType;
    private Date launchTime;
    private Placement placement;
    private String kernelId;
    private String ramdiskId;
    private String platform;
    private Monitoring monitoring;
    private String subnetId;
    private String vpcId;
    private String privateIpAddress;
    private String publicIpAddress;
    private StateReason stateReason;
    private String architecture;
    private String rootDeviceType;
    private String rootDeviceName;
    private List<InstanceBlockDeviceMapping> blockDeviceMappings;
    private String virtualizationType;
    private String instanceLifecycle;
    private String spotInstanceRequestId;
    private InstanceLicense license;
    private String clientToken;
    private List<Tag> tags;
    private List<GroupIdentifier> securityGroups;
    private Boolean sourceDestCheck;
    private String hypervisor;

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public Instance withInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public Instance withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public InstanceState getState() {
        return this.state;
    }

    public void setState(InstanceState state) {
        this.state = state;
    }

    public Instance withState(InstanceState state) {
        this.state = state;
        return this;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    public Instance withPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
        return this;
    }

    public String getPublicDnsName() {
        return this.publicDnsName;
    }

    public void setPublicDnsName(String publicDnsName) {
        this.publicDnsName = publicDnsName;
    }

    public Instance withPublicDnsName(String publicDnsName) {
        this.publicDnsName = publicDnsName;
        return this;
    }

    public String getStateTransitionReason() {
        return this.stateTransitionReason;
    }

    public void setStateTransitionReason(String stateTransitionReason) {
        this.stateTransitionReason = stateTransitionReason;
    }

    public Instance withStateTransitionReason(String stateTransitionReason) {
        this.stateTransitionReason = stateTransitionReason;
        return this;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Instance withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public Integer getAmiLaunchIndex() {
        return this.amiLaunchIndex;
    }

    public void setAmiLaunchIndex(Integer amiLaunchIndex) {
        this.amiLaunchIndex = amiLaunchIndex;
    }

    public Instance withAmiLaunchIndex(Integer amiLaunchIndex) {
        this.amiLaunchIndex = amiLaunchIndex;
        return this;
    }

    public List<ProductCode> getProductCodes() {
        if (this.productCodes == null) {
            this.productCodes = new ArrayList<ProductCode>();
        }
        return this.productCodes;
    }

    public void setProductCodes(Collection<ProductCode> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
            return;
        }
        ArrayList<ProductCode> productCodesCopy = new ArrayList<ProductCode>(productCodes.size());
        productCodesCopy.addAll(productCodes);
        this.productCodes = productCodesCopy;
    }

    public Instance withProductCodes(ProductCode ... productCodes) {
        if (this.getProductCodes() == null) {
            this.setProductCodes(new ArrayList<ProductCode>(productCodes.length));
        }
        for (ProductCode value : productCodes) {
            this.getProductCodes().add(value);
        }
        return this;
    }

    public Instance withProductCodes(Collection<ProductCode> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
        } else {
            ArrayList<ProductCode> productCodesCopy = new ArrayList<ProductCode>(productCodes.size());
            productCodesCopy.addAll(productCodes);
            this.productCodes = productCodesCopy;
        }
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public Instance withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public void setInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
    }

    public Instance withInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public Date getLaunchTime() {
        return this.launchTime;
    }

    public void setLaunchTime(Date launchTime) {
        this.launchTime = launchTime;
    }

    public Instance withLaunchTime(Date launchTime) {
        this.launchTime = launchTime;
        return this;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public void setPlacement(Placement placement) {
        this.placement = placement;
    }

    public Instance withPlacement(Placement placement) {
        this.placement = placement;
        return this;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public Instance withKernelId(String kernelId) {
        this.kernelId = kernelId;
        return this;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public Instance withRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
        return this;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Instance withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public Monitoring getMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(Monitoring monitoring) {
        this.monitoring = monitoring;
    }

    public Instance withMonitoring(Monitoring monitoring) {
        this.monitoring = monitoring;
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public Instance withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public Instance withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public Instance withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public String getPublicIpAddress() {
        return this.publicIpAddress;
    }

    public void setPublicIpAddress(String publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
    }

    public Instance withPublicIpAddress(String publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    public StateReason getStateReason() {
        return this.stateReason;
    }

    public void setStateReason(StateReason stateReason) {
        this.stateReason = stateReason;
    }

    public Instance withStateReason(StateReason stateReason) {
        this.stateReason = stateReason;
        return this;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public Instance withArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    public void setRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
    }

    public Instance withRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
        return this;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public void setRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
    }

    public Instance withRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
        return this;
    }

    public List<InstanceBlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<InstanceBlockDeviceMapping>();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        ArrayList<InstanceBlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<InstanceBlockDeviceMapping>(blockDeviceMappings.size());
        blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public Instance withBlockDeviceMappings(InstanceBlockDeviceMapping ... blockDeviceMappings) {
        if (this.getBlockDeviceMappings() == null) {
            this.setBlockDeviceMappings(new ArrayList<InstanceBlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (InstanceBlockDeviceMapping value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public Instance withBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
        } else {
            ArrayList<InstanceBlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<InstanceBlockDeviceMapping>(blockDeviceMappings.size());
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
            this.blockDeviceMappings = blockDeviceMappingsCopy;
        }
        return this;
    }

    public String getVirtualizationType() {
        return this.virtualizationType;
    }

    public void setVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
    }

    public Instance withVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
        return this;
    }

    public void setVirtualizationType(VirtualizationType virtualizationType) {
        this.virtualizationType = virtualizationType.toString();
    }

    public Instance withVirtualizationType(VirtualizationType virtualizationType) {
        this.virtualizationType = virtualizationType.toString();
        return this;
    }

    public String getInstanceLifecycle() {
        return this.instanceLifecycle;
    }

    public void setInstanceLifecycle(String instanceLifecycle) {
        this.instanceLifecycle = instanceLifecycle;
    }

    public Instance withInstanceLifecycle(String instanceLifecycle) {
        this.instanceLifecycle = instanceLifecycle;
        return this;
    }

    public String getSpotInstanceRequestId() {
        return this.spotInstanceRequestId;
    }

    public void setSpotInstanceRequestId(String spotInstanceRequestId) {
        this.spotInstanceRequestId = spotInstanceRequestId;
    }

    public Instance withSpotInstanceRequestId(String spotInstanceRequestId) {
        this.spotInstanceRequestId = spotInstanceRequestId;
        return this;
    }

    public InstanceLicense getLicense() {
        return this.license;
    }

    public void setLicense(InstanceLicense license) {
        this.license = license;
    }

    public Instance withLicense(InstanceLicense license) {
        this.license = license;
        return this;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public Instance withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public Instance withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public Instance withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public List<GroupIdentifier> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<GroupIdentifier>();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<GroupIdentifier> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        ArrayList<GroupIdentifier> securityGroupsCopy = new ArrayList<GroupIdentifier>(securityGroups.size());
        securityGroupsCopy.addAll(securityGroups);
        this.securityGroups = securityGroupsCopy;
    }

    public Instance withSecurityGroups(GroupIdentifier ... securityGroups) {
        if (this.getSecurityGroups() == null) {
            this.setSecurityGroups(new ArrayList<GroupIdentifier>(securityGroups.length));
        }
        for (GroupIdentifier value : securityGroups) {
            this.getSecurityGroups().add(value);
        }
        return this;
    }

    public Instance withSecurityGroups(Collection<GroupIdentifier> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
        } else {
            ArrayList<GroupIdentifier> securityGroupsCopy = new ArrayList<GroupIdentifier>(securityGroups.size());
            securityGroupsCopy.addAll(securityGroups);
            this.securityGroups = securityGroupsCopy;
        }
        return this;
    }

    public Boolean isSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public void setSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
    }

    public Instance withSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
        return this;
    }

    public Boolean getSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public void setHypervisor(String hypervisor) {
        this.hypervisor = hypervisor;
    }

    public Instance withHypervisor(String hypervisor) {
        this.hypervisor = hypervisor;
        return this;
    }

    public void setHypervisor(HypervisorType hypervisor) {
        this.hypervisor = hypervisor.toString();
    }

    public Instance withHypervisor(HypervisorType hypervisor) {
        this.hypervisor = hypervisor.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId != null) {
            sb.append("InstanceId: " + this.instanceId + ", ");
        }
        if (this.imageId != null) {
            sb.append("ImageId: " + this.imageId + ", ");
        }
        if (this.state != null) {
            sb.append("State: " + this.state + ", ");
        }
        if (this.privateDnsName != null) {
            sb.append("PrivateDnsName: " + this.privateDnsName + ", ");
        }
        if (this.publicDnsName != null) {
            sb.append("PublicDnsName: " + this.publicDnsName + ", ");
        }
        if (this.stateTransitionReason != null) {
            sb.append("StateTransitionReason: " + this.stateTransitionReason + ", ");
        }
        if (this.keyName != null) {
            sb.append("KeyName: " + this.keyName + ", ");
        }
        if (this.amiLaunchIndex != null) {
            sb.append("AmiLaunchIndex: " + this.amiLaunchIndex + ", ");
        }
        if (this.productCodes != null) {
            sb.append("ProductCodes: " + this.productCodes + ", ");
        }
        if (this.instanceType != null) {
            sb.append("InstanceType: " + this.instanceType + ", ");
        }
        if (this.launchTime != null) {
            sb.append("LaunchTime: " + this.launchTime + ", ");
        }
        if (this.placement != null) {
            sb.append("Placement: " + this.placement + ", ");
        }
        if (this.kernelId != null) {
            sb.append("KernelId: " + this.kernelId + ", ");
        }
        if (this.ramdiskId != null) {
            sb.append("RamdiskId: " + this.ramdiskId + ", ");
        }
        if (this.platform != null) {
            sb.append("Platform: " + this.platform + ", ");
        }
        if (this.monitoring != null) {
            sb.append("Monitoring: " + this.monitoring + ", ");
        }
        if (this.subnetId != null) {
            sb.append("SubnetId: " + this.subnetId + ", ");
        }
        if (this.vpcId != null) {
            sb.append("VpcId: " + this.vpcId + ", ");
        }
        if (this.privateIpAddress != null) {
            sb.append("PrivateIpAddress: " + this.privateIpAddress + ", ");
        }
        if (this.publicIpAddress != null) {
            sb.append("PublicIpAddress: " + this.publicIpAddress + ", ");
        }
        if (this.stateReason != null) {
            sb.append("StateReason: " + this.stateReason + ", ");
        }
        if (this.architecture != null) {
            sb.append("Architecture: " + this.architecture + ", ");
        }
        if (this.rootDeviceType != null) {
            sb.append("RootDeviceType: " + this.rootDeviceType + ", ");
        }
        if (this.rootDeviceName != null) {
            sb.append("RootDeviceName: " + this.rootDeviceName + ", ");
        }
        if (this.blockDeviceMappings != null) {
            sb.append("BlockDeviceMappings: " + this.blockDeviceMappings + ", ");
        }
        if (this.virtualizationType != null) {
            sb.append("VirtualizationType: " + this.virtualizationType + ", ");
        }
        if (this.instanceLifecycle != null) {
            sb.append("InstanceLifecycle: " + this.instanceLifecycle + ", ");
        }
        if (this.spotInstanceRequestId != null) {
            sb.append("SpotInstanceRequestId: " + this.spotInstanceRequestId + ", ");
        }
        if (this.license != null) {
            sb.append("License: " + this.license + ", ");
        }
        if (this.clientToken != null) {
            sb.append("ClientToken: " + this.clientToken + ", ");
        }
        if (this.tags != null) {
            sb.append("Tags: " + this.tags + ", ");
        }
        if (this.securityGroups != null) {
            sb.append("SecurityGroups: " + this.securityGroups + ", ");
        }
        if (this.sourceDestCheck != null) {
            sb.append("SourceDestCheck: " + this.sourceDestCheck + ", ");
        }
        if (this.hypervisor != null) {
            sb.append("Hypervisor: " + this.hypervisor + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsName() == null ? 0 : this.getPrivateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getPublicDnsName() == null ? 0 : this.getPublicDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getStateTransitionReason() == null ? 0 : this.getStateTransitionReason().hashCode());
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getAmiLaunchIndex() == null ? 0 : this.getAmiLaunchIndex().hashCode());
        hashCode = 31 * hashCode + (this.getProductCodes() == null ? 0 : ((Object)this.getProductCodes()).hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchTime() == null ? 0 : this.getLaunchTime().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoring() == null ? 0 : this.getMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPublicIpAddress() == null ? 0 : this.getPublicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getStateReason() == null ? 0 : this.getStateReason().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceType() == null ? 0 : this.getRootDeviceType().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceName() == null ? 0 : this.getRootDeviceName().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : ((Object)this.getBlockDeviceMappings()).hashCode());
        hashCode = 31 * hashCode + (this.getVirtualizationType() == null ? 0 : this.getVirtualizationType().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceLifecycle() == null ? 0 : this.getInstanceLifecycle().hashCode());
        hashCode = 31 * hashCode + (this.getSpotInstanceRequestId() == null ? 0 : this.getSpotInstanceRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getLicense() == null ? 0 : this.getLicense().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : ((Object)this.getSecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.isSourceDestCheck() == null ? 0 : this.isSourceDestCheck().hashCode());
        hashCode = 31 * hashCode + (this.getHypervisor() == null ? 0 : this.getHypervisor().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getPrivateDnsName() == null ^ this.getPrivateDnsName() == null) {
            return false;
        }
        if (other.getPrivateDnsName() != null && !other.getPrivateDnsName().equals(this.getPrivateDnsName())) {
            return false;
        }
        if (other.getPublicDnsName() == null ^ this.getPublicDnsName() == null) {
            return false;
        }
        if (other.getPublicDnsName() != null && !other.getPublicDnsName().equals(this.getPublicDnsName())) {
            return false;
        }
        if (other.getStateTransitionReason() == null ^ this.getStateTransitionReason() == null) {
            return false;
        }
        if (other.getStateTransitionReason() != null && !other.getStateTransitionReason().equals(this.getStateTransitionReason())) {
            return false;
        }
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getAmiLaunchIndex() == null ^ this.getAmiLaunchIndex() == null) {
            return false;
        }
        if (other.getAmiLaunchIndex() != null && !other.getAmiLaunchIndex().equals(this.getAmiLaunchIndex())) {
            return false;
        }
        if (other.getProductCodes() == null ^ this.getProductCodes() == null) {
            return false;
        }
        if (other.getProductCodes() != null && !((Object)other.getProductCodes()).equals(this.getProductCodes())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getLaunchTime() == null ^ this.getLaunchTime() == null) {
            return false;
        }
        if (other.getLaunchTime() != null && !other.getLaunchTime().equals(this.getLaunchTime())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getMonitoring() == null ^ this.getMonitoring() == null) {
            return false;
        }
        if (other.getMonitoring() != null && !other.getMonitoring().equals(this.getMonitoring())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getPublicIpAddress() == null ^ this.getPublicIpAddress() == null) {
            return false;
        }
        if (other.getPublicIpAddress() != null && !other.getPublicIpAddress().equals(this.getPublicIpAddress())) {
            return false;
        }
        if (other.getStateReason() == null ^ this.getStateReason() == null) {
            return false;
        }
        if (other.getStateReason() != null && !other.getStateReason().equals(this.getStateReason())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getRootDeviceType() == null ^ this.getRootDeviceType() == null) {
            return false;
        }
        if (other.getRootDeviceType() != null && !other.getRootDeviceType().equals(this.getRootDeviceType())) {
            return false;
        }
        if (other.getRootDeviceName() == null ^ this.getRootDeviceName() == null) {
            return false;
        }
        if (other.getRootDeviceName() != null && !other.getRootDeviceName().equals(this.getRootDeviceName())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !((Object)other.getBlockDeviceMappings()).equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getVirtualizationType() == null ^ this.getVirtualizationType() == null) {
            return false;
        }
        if (other.getVirtualizationType() != null && !other.getVirtualizationType().equals(this.getVirtualizationType())) {
            return false;
        }
        if (other.getInstanceLifecycle() == null ^ this.getInstanceLifecycle() == null) {
            return false;
        }
        if (other.getInstanceLifecycle() != null && !other.getInstanceLifecycle().equals(this.getInstanceLifecycle())) {
            return false;
        }
        if (other.getSpotInstanceRequestId() == null ^ this.getSpotInstanceRequestId() == null) {
            return false;
        }
        if (other.getSpotInstanceRequestId() != null && !other.getSpotInstanceRequestId().equals(this.getSpotInstanceRequestId())) {
            return false;
        }
        if (other.getLicense() == null ^ this.getLicense() == null) {
            return false;
        }
        if (other.getLicense() != null && !other.getLicense().equals(this.getLicense())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !((Object)other.getTags()).equals(this.getTags())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !((Object)other.getSecurityGroups()).equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.isSourceDestCheck() == null ^ this.isSourceDestCheck() == null) {
            return false;
        }
        if (other.isSourceDestCheck() != null && !other.isSourceDestCheck().equals(this.isSourceDestCheck())) {
            return false;
        }
        if (other.getHypervisor() == null ^ this.getHypervisor() == null) {
            return false;
        }
        return other.getHypervisor() == null || other.getHypervisor().equals(this.getHypervisor());
    }
}

