/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.datamodeling.internal;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodb.AmazonDynamoDB;
import com.amazonaws.services.dynamodb.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodb.datamodeling.internal.UnmodifiableIterator;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PaginatedList<T>
implements List<T> {
    private static final String UNMODIFIABLE_MESSAGE = "This is an unmodifiable list";
    protected final DynamoDBMapper mapper;
    protected final Class<T> clazz;
    protected final AmazonDynamoDB dynamo;
    private final int size;
    protected boolean allResultsLoaded = false;
    protected List<T> allResults;

    public PaginatedList(DynamoDBMapper mapper, Class<T> clazz, AmazonDynamoDB dynamo, int size) {
        this.mapper = mapper;
        this.clazz = clazz;
        this.dynamo = dynamo;
        this.size = size;
        this.allResults = new ArrayList<T>();
    }

    protected synchronized void loadAllResults() {
        if (this.allResultsLoaded) {
            return;
        }
        while (this.hasMoreResults()) {
            this.loadNextResult();
        }
        this.allResultsLoaded = true;
    }

    protected abstract boolean hasMoreResults();

    protected abstract void loadNextResult();

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.allResults.isEmpty();
    }

    @Override
    public boolean contains(Object arg0) {
        this.loadAllResults();
        return this.allResults.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        this.loadAllResults();
        return this.allResults.containsAll(arg0);
    }

    @Override
    public T get(int arg0) {
        this.loadAllResults();
        return this.allResults.get(arg0);
    }

    @Override
    public int indexOf(Object arg0) {
        this.loadAllResults();
        return this.allResults.indexOf(arg0);
    }

    @Override
    public int lastIndexOf(Object arg0) {
        this.loadAllResults();
        return this.allResults.lastIndexOf(arg0);
    }

    @Override
    public List<T> subList(int arg0, int arg1) {
        this.loadAllResults();
        return this.allResults.subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        this.loadAllResults();
        return this.allResults.toArray();
    }

    @Override
    public <X> X[] toArray(X[] a) {
        this.loadAllResults();
        return this.allResults.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        final UnmodifiableIterator<T> iter = new UnmodifiableIterator<T>(this.allResults.iterator());
        return new Iterator<T>(){
            Iterator<T> iterator;
            int pos;
            {
                this.iterator = iter;
                this.pos = 0;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext() || PaginatedList.this.hasMoreResults();
            }

            @Override
            public T next() {
                if (!this.iterator.hasNext() && PaginatedList.this.hasMoreResults()) {
                    PaginatedList.this.loadNextResult();
                    this.iterator = new UnmodifiableIterator(PaginatedList.this.allResults.listIterator(this.pos));
                }
                ++this.pos;
                return this.iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException(PaginatedList.UNMODIFIABLE_MESSAGE);
            }
        };
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("ListIterators are not supported for this list");
    }

    @Override
    public ListIterator<T> listIterator(int arg0) {
        throw new UnsupportedOperationException("ListIterators are not supported for this list");
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public T remove(int arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public T set(int arg0, T arg1) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean add(T arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public void add(int arg0, T arg1) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(UNMODIFIABLE_MESSAGE);
    }

    protected void unmarshallResults(List<Map<String, AttributeValue>> items) {
        for (Map<String, AttributeValue> attributeMap : items) {
            try {
                this.allResults.add(this.mapper.marshallIntoObject(this.clazz, attributeMap));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to marshall attributes into object", e);
            }
        }
    }

    static <X extends AmazonWebServiceRequest> X applyUserAgent(X request) {
        request.getRequestClientOptions().addClientMarker(DynamoDBMapper.USER_AGENT);
        return request;
    }
}

