/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.internal.ProgressListenerChain;
import java.io.IOException;

public class Download
extends Transfer {
    private final S3Object s3Object;

    public Download(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, S3Object s3Object) {
        super(description, transferProgress, progressListenerChain);
        this.s3Object = s3Object;
    }

    public ObjectMetadata getObjectMetadata() {
        return this.s3Object.getObjectMetadata();
    }

    public String getBucketName() {
        return this.s3Object.getBucketName();
    }

    public String getKey() {
        return this.s3Object.getKey();
    }

    public void abort() throws IOException {
        this.s3Object.getObjectContent().abort();
        this.state = Transfer.TransferState.Canceled;
    }
}

