
/**
 * Synchronous and asynchronous client classes for accessing AmazonSNS.
 *
 * Amazon Simple Notification Service <p>
 * This is the <i>Amazon Simple Notification Service (Amazon SNS) API
 * Reference</i> . This guide provides detailed information about Amazon
 * SNS actions, data types, parameters, and errors. For detailed
 * information about Amazon SNS features and their associated API calls,
 * go to the <a href="http://docs.amazonwebservices.com/sns/latest/gsg/">
 * Amazon SNS Getting Started Guide </a> .
 * </p>
 * <p>
 * Amazon Simple Notification Service is a web service that enables you
 * to build distributed web-enabled applications. Applications can use
 * Amazon SNS to easily push real-time notification messages to
 * interested subscribers over multiple delivery protocols. For more
 * information about this product go to <a
 * href="http://aws.amazon.com/sns/"> http://aws.amazon.com/sns </a> .
 * </p>
 * <p>
 * Use the following links to get started using the <i>Amazon Simple
 * Notification Service API Reference</i> :
 * </p>
 * 
 * <ul>
 * <li> <a
 * http://docs.amazonwebservices.com/sns/latest/api/API_Operations.html">
 * Actions </a> : An alphabetical list of all Amazon SNS actions.</li>
 * <li> <a
 * ref="http://docs.amazonwebservices.com/sns/latest/api/API_Types.html">
 * Data Types </a> : An alphabetical list of all Amazon SNS data
 * types.</li>
 * <li> <a
 * tp://docs.amazonwebservices.com/sns/latest/api/CommonParameters.html">
 * Common Parameters </a> : Parameters that all Query actions can
 * use.</li>
 * <li> <a
 * ="http://docs.amazonwebservices.com/sns/latest/api/CommonErrors.html">
 * Common Errors </a> : Client and server errors that all actions can
 * return.</li>
 * <li> <a
 * //docs.amazonwebservices.com/general/latest/gr/index.html?rande.html">
 * Regions and Endpoints </a> : Itemized regions and endpoints for all
 * AWS products.</li>
 * <li> <a
 * s-east-1.amazonaws.com/doc/2010-03-31/SimpleNotificationService.wsdl">
 * WSDL Location </a> :
 * ast-1.amazonaws.com/doc/2010-03-31/SimpleNotificationService.wsdl</li>
 * 
 * </ul>
 */
 package com.amazonaws.services.sns;
        