
/**
 * Synchronous and asynchronous client classes for accessing AWSStorageGateway.
 *
 * AWS Storage Gateway Service <p>
 * AWS Storage Gateway is a service that connects an on-premises software
 * appliance with cloud-based storage to provide seamless and secure
 * integration between an organization's on-premises IT environment and
 * AWS's storage infrastructure. The service enables you to securely
 * upload data to the AWS cloud for cost effective backup and rapid
 * disaster recovery.
 * </p>
 * <p>
 * Use the following links to get started using the <i>AWS Storage
 * Gateway Service API Reference</i> :
 * </p>
 * 
 * <ul>
 * <li> <a
 * .amazonwebservices.com/storagegateway/latest/api/API_Operations.html">
 * Actions </a> : An alphabetical list of all AWS Storage Gateway
 * actions.</li>
 * <li> <a
 * mazonwebservices.com/storagegateway/latest/api/CommonParameters.html">
 * Common Parameters </a> : Parameters that all Query actions can
 * use.</li>
 * <li> <a
 * cs.amazonwebservices.com/storagegateway/latest/api/CommonErrors.html">
 * Common Errors </a> : Client and server errors that all actions can
 * return.</li>
 * <li> <a
 * //docs.amazonwebservices.com/general/latest/gr/index.html?rande.html">
 * Regions and Endpoints </a> : Itemized regions and endpoints for all
 * AWS products.</li>
 * <li> <a
 * s-east-1.amazonaws.com/doc/2010-03-31/SimpleNotificationService.wsdl">
 * WSDL Location </a> :
 * east-1.amazonaws.com/doc/2012-04-15/AWSStorageGatewayService.wsdl</li>
 * 
 * </ul>
 */
 package com.amazonaws.services.storagegateway;
        