/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodb.model.ReturnValue;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutItemRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String tableName;
    private Map<String, AttributeValue> item;
    private Map<String, ExpectedAttributeValue> expected;
    private String returnValues;

    public PutItemRequest() {
    }

    public PutItemRequest(String tableName, Map<String, AttributeValue> item) {
        this.tableName = tableName;
        this.item = item;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public PutItemRequest withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Map<String, AttributeValue> getItem() {
        return this.item;
    }

    public void setItem(Map<String, AttributeValue> item) {
        this.item = item;
    }

    public PutItemRequest withItem(Map<String, AttributeValue> item) {
        this.setItem(item);
        return this;
    }

    public Map<String, ExpectedAttributeValue> getExpected() {
        return this.expected;
    }

    public void setExpected(Map<String, ExpectedAttributeValue> expected) {
        this.expected = expected;
    }

    public PutItemRequest withExpected(Map<String, ExpectedAttributeValue> expected) {
        this.setExpected(expected);
        return this;
    }

    public String getReturnValues() {
        return this.returnValues;
    }

    public void setReturnValues(String returnValues) {
        this.returnValues = returnValues;
    }

    public PutItemRequest withReturnValues(String returnValues) {
        this.returnValues = returnValues;
        return this;
    }

    public void setReturnValues(ReturnValue returnValues) {
        this.returnValues = returnValues.toString();
    }

    public PutItemRequest withReturnValues(ReturnValue returnValues) {
        this.returnValues = returnValues.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTableName() != null) {
            sb.append("TableName: " + this.getTableName() + ", ");
        }
        if (this.getItem() != null) {
            sb.append("Item: " + this.getItem() + ", ");
        }
        if (this.getExpected() != null) {
            sb.append("Expected: " + this.getExpected() + ", ");
        }
        if (this.getReturnValues() != null) {
            sb.append("ReturnValues: " + this.getReturnValues() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getItem() == null ? 0 : ((Object)this.getItem()).hashCode());
        hashCode = 31 * hashCode + (this.getExpected() == null ? 0 : ((Object)this.getExpected()).hashCode());
        hashCode = 31 * hashCode + (this.getReturnValues() == null ? 0 : this.getReturnValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutItemRequest)) {
            return false;
        }
        PutItemRequest other = (PutItemRequest)obj;
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getItem() == null ^ this.getItem() == null) {
            return false;
        }
        if (other.getItem() != null && !((Object)other.getItem()).equals(this.getItem())) {
            return false;
        }
        if (other.getExpected() == null ^ this.getExpected() == null) {
            return false;
        }
        if (other.getExpected() != null && !((Object)other.getExpected()).equals(this.getExpected())) {
            return false;
        }
        if (other.getReturnValues() == null ^ this.getReturnValues() == null) {
            return false;
        }
        return other.getReturnValues() == null || other.getReturnValues().equals(this.getReturnValues());
    }
}

