/*
 * Copyright 2010-2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.elasticloadbalancing.model;
import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;

/**
 * Container for the parameters to the {@link com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing#deleteLoadBalancerListeners(DeleteLoadBalancerListenersRequest) DeleteLoadBalancerListeners operation}.
 * <p>
 * Deletes listeners from the LoadBalancer for the specified port.
 * </p>
 *
 * @see com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing#deleteLoadBalancerListeners(DeleteLoadBalancerListenersRequest)
 */
public class DeleteLoadBalancerListenersRequest extends AmazonWebServiceRequest  implements Serializable  {

    /**
     * The mnemonic name associated with the LoadBalancer.
     */
    private String loadBalancerName;

    /**
     * The client port number(s) of the LoadBalancerListener(s) to be
     * removed.
     */
    private java.util.List<Integer> loadBalancerPorts;

    /**
     * Default constructor for a new DeleteLoadBalancerListenersRequest object.  Callers should use the
     * setter or fluent setter (with...) methods to initialize this object after creating it.
     */
    public DeleteLoadBalancerListenersRequest() {}
    
    /**
     * Constructs a new DeleteLoadBalancerListenersRequest object.
     * Callers should use the setter or fluent setter (with...) methods to
     * initialize any additional object members.
     * 
     * @param loadBalancerName The mnemonic name associated with the
     * LoadBalancer.
     * @param loadBalancerPorts The client port number(s) of the
     * LoadBalancerListener(s) to be removed.
     */
    public DeleteLoadBalancerListenersRequest(String loadBalancerName, java.util.List<Integer> loadBalancerPorts) {
        this.loadBalancerName = loadBalancerName;
        this.loadBalancerPorts = loadBalancerPorts;
    }

    
    
    /**
     * The mnemonic name associated with the LoadBalancer.
     *
     * @return The mnemonic name associated with the LoadBalancer.
     */
    public String getLoadBalancerName() {
        return loadBalancerName;
    }
    
    /**
     * The mnemonic name associated with the LoadBalancer.
     *
     * @param loadBalancerName The mnemonic name associated with the LoadBalancer.
     */
    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }
    
    /**
     * The mnemonic name associated with the LoadBalancer.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param loadBalancerName The mnemonic name associated with the LoadBalancer.
     *
     * @return A reference to this updated object so that method calls can be chained 
     *         together. 
     */
    public DeleteLoadBalancerListenersRequest withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }
    
    
    /**
     * The client port number(s) of the LoadBalancerListener(s) to be
     * removed.
     *
     * @return The client port number(s) of the LoadBalancerListener(s) to be
     *         removed.
     */
    public java.util.List<Integer> getLoadBalancerPorts() {
        
        if (loadBalancerPorts == null) {
            loadBalancerPorts = new java.util.ArrayList<Integer>();
        }
        return loadBalancerPorts;
    }
    
    /**
     * The client port number(s) of the LoadBalancerListener(s) to be
     * removed.
     *
     * @param loadBalancerPorts The client port number(s) of the LoadBalancerListener(s) to be
     *         removed.
     */
    public void setLoadBalancerPorts(java.util.Collection<Integer> loadBalancerPorts) {
        if (loadBalancerPorts == null) {
            this.loadBalancerPorts = null;
            return;
        }

        java.util.List<Integer> loadBalancerPortsCopy = new java.util.ArrayList<Integer>(loadBalancerPorts.size());
        loadBalancerPortsCopy.addAll(loadBalancerPorts);
        this.loadBalancerPorts = loadBalancerPortsCopy;
    }
    
    /**
     * The client port number(s) of the LoadBalancerListener(s) to be
     * removed.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param loadBalancerPorts The client port number(s) of the LoadBalancerListener(s) to be
     *         removed.
     *
     * @return A reference to this updated object so that method calls can be chained 
     *         together. 
     */
    public DeleteLoadBalancerListenersRequest withLoadBalancerPorts(Integer... loadBalancerPorts) {
        if (getLoadBalancerPorts() == null) setLoadBalancerPorts(new java.util.ArrayList<Integer>(loadBalancerPorts.length));
        for (Integer value : loadBalancerPorts) {
            getLoadBalancerPorts().add(value);
        }
        return this;
    }
    
    /**
     * The client port number(s) of the LoadBalancerListener(s) to be
     * removed.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param loadBalancerPorts The client port number(s) of the LoadBalancerListener(s) to be
     *         removed.
     *
     * @return A reference to this updated object so that method calls can be chained 
     *         together. 
     */
    public DeleteLoadBalancerListenersRequest withLoadBalancerPorts(java.util.Collection<Integer> loadBalancerPorts) {
        if (loadBalancerPorts == null) {
            this.loadBalancerPorts = null;
        } else {
            java.util.List<Integer> loadBalancerPortsCopy = new java.util.ArrayList<Integer>(loadBalancerPorts.size());
            loadBalancerPortsCopy.addAll(loadBalancerPorts);
            this.loadBalancerPorts = loadBalancerPortsCopy;
        }

        return this;
    }
    
    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");    	
        if (getLoadBalancerName() != null) sb.append("LoadBalancerName: " + getLoadBalancerName() + ",");    	
        if (getLoadBalancerPorts() != null) sb.append("LoadBalancerPorts: " + getLoadBalancerPorts() );
        sb.append("}");
        return sb.toString();
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;
        
        hashCode = prime * hashCode + ((getLoadBalancerName() == null) ? 0 : getLoadBalancerName().hashCode()); 
        hashCode = prime * hashCode + ((getLoadBalancerPorts() == null) ? 0 : getLoadBalancerPorts().hashCode()); 
        return hashCode;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;

        if (obj instanceof DeleteLoadBalancerListenersRequest == false) return false;
        DeleteLoadBalancerListenersRequest other = (DeleteLoadBalancerListenersRequest)obj;
        
        if (other.getLoadBalancerName() == null ^ this.getLoadBalancerName() == null) return false;
        if (other.getLoadBalancerName() != null && other.getLoadBalancerName().equals(this.getLoadBalancerName()) == false) return false; 
        if (other.getLoadBalancerPorts() == null ^ this.getLoadBalancerPorts() == null) return false;
        if (other.getLoadBalancerPorts() != null && other.getLoadBalancerPorts().equals(this.getLoadBalancerPorts()) == false) return false; 
        return true;
    }
    
}
    