/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisableAvailabilityZonesForLoadBalancerRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String loadBalancerName;
    private List<String> availabilityZones;

    public DisableAvailabilityZonesForLoadBalancerRequest() {
    }

    public DisableAvailabilityZonesForLoadBalancerRequest(String loadBalancerName, List<String> availabilityZones) {
        this.loadBalancerName = loadBalancerName;
        this.availabilityZones = availabilityZones;
    }

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public DisableAvailabilityZonesForLoadBalancerRequest withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ArrayList<String>();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        ArrayList<String> availabilityZonesCopy = new ArrayList<String>(availabilityZones.size());
        availabilityZonesCopy.addAll(availabilityZones);
        this.availabilityZones = availabilityZonesCopy;
    }

    public DisableAvailabilityZonesForLoadBalancerRequest withAvailabilityZones(String ... availabilityZones) {
        if (this.getAvailabilityZones() == null) {
            this.setAvailabilityZones(new ArrayList<String>(availabilityZones.length));
        }
        for (String value : availabilityZones) {
            this.getAvailabilityZones().add(value);
        }
        return this;
    }

    public DisableAvailabilityZonesForLoadBalancerRequest withAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
        } else {
            ArrayList<String> availabilityZonesCopy = new ArrayList<String>(availabilityZones.size());
            availabilityZonesCopy.addAll(availabilityZones);
            this.availabilityZones = availabilityZonesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerName() != null) {
            sb.append("LoadBalancerName: " + this.getLoadBalancerName() + ",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: " + this.getAvailabilityZones());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerName() == null ? 0 : this.getLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : ((Object)this.getAvailabilityZones()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableAvailabilityZonesForLoadBalancerRequest)) {
            return false;
        }
        DisableAvailabilityZonesForLoadBalancerRequest other = (DisableAvailabilityZonesForLoadBalancerRequest)obj;
        if (other.getLoadBalancerName() == null ^ this.getLoadBalancerName() == null) {
            return false;
        }
        if (other.getLoadBalancerName() != null && !other.getLoadBalancerName().equals(this.getLoadBalancerName())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        return other.getAvailabilityZones() == null || ((Object)other.getAvailabilityZones()).equals(this.getAvailabilityZones());
    }
}

