/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS3Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.model.DeleteIdentityRequest;
import com.amazonaws.services.simpleemail.model.DeleteIdentityResult;
import com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesResult;
import com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesResult;
import com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest;
import com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesResult;
import com.amazonaws.services.simpleemail.model.GetSendQuotaRequest;
import com.amazonaws.services.simpleemail.model.GetSendQuotaResult;
import com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest;
import com.amazonaws.services.simpleemail.model.GetSendStatisticsResult;
import com.amazonaws.services.simpleemail.model.ListIdentitiesRequest;
import com.amazonaws.services.simpleemail.model.ListIdentitiesResult;
import com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest;
import com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesResult;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.services.simpleemail.model.SendEmailResult;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest;
import com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledResult;
import com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest;
import com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledResult;
import com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest;
import com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicResult;
import com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest;
import com.amazonaws.services.simpleemail.model.VerifyDomainDkimResult;
import com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest;
import com.amazonaws.services.simpleemail.model.VerifyDomainIdentityResult;
import com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest;
import com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest;
import com.amazonaws.services.simpleemail.model.VerifyEmailIdentityResult;
import com.amazonaws.services.simpleemail.model.transform.DeleteIdentityRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.DeleteIdentityResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.DeleteVerifiedEmailAddressRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetIdentityDkimAttributesRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetIdentityDkimAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetIdentityNotificationAttributesRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetIdentityNotificationAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetIdentityVerificationAttributesRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetIdentityVerificationAttributesResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetSendQuotaRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetSendQuotaResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetSendStatisticsRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetSendStatisticsResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.ListIdentitiesRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.ListIdentitiesResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.ListVerifiedEmailAddressesRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.ListVerifiedEmailAddressesResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.MessageRejectedExceptionUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.SendEmailRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.SendEmailResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.SendRawEmailRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.SendRawEmailResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.SetIdentityDkimEnabledRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.SetIdentityDkimEnabledResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.SetIdentityFeedbackForwardingEnabledRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.SetIdentityFeedbackForwardingEnabledResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.SetIdentityNotificationTopicRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.SetIdentityNotificationTopicResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyDomainDkimRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyDomainDkimResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyDomainIdentityRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyDomainIdentityResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyEmailAddressRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyEmailIdentityRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyEmailIdentityResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleEmailServiceClient
extends AmazonWebServiceClient
implements AmazonSimpleEmailService {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS3Signer signer;

    public AmazonSimpleEmailServiceClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonSimpleEmailServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonSimpleEmailServiceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSimpleEmailServiceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonSimpleEmailServiceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonSimpleEmailServiceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new MessageRejectedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("email.us-east-1.amazonaws.com");
        this.signer = new AWS3Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simpleemail/request.handlers"));
    }

    @Override
    public DeleteIdentityResult deleteIdentity(DeleteIdentityRequest deleteIdentityRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteIdentityRequest> request = new DeleteIdentityRequestMarshaller().marshall(deleteIdentityRequest);
        return this.invoke(request, new DeleteIdentityResultStaxUnmarshaller());
    }

    @Override
    public ListVerifiedEmailAddressesResult listVerifiedEmailAddresses(ListVerifiedEmailAddressesRequest listVerifiedEmailAddressesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListVerifiedEmailAddressesRequest> request = new ListVerifiedEmailAddressesRequestMarshaller().marshall(listVerifiedEmailAddressesRequest);
        return this.invoke(request, new ListVerifiedEmailAddressesResultStaxUnmarshaller());
    }

    @Override
    public GetSendStatisticsResult getSendStatistics(GetSendStatisticsRequest getSendStatisticsRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetSendStatisticsRequest> request = new GetSendStatisticsRequestMarshaller().marshall(getSendStatisticsRequest);
        return this.invoke(request, new GetSendStatisticsResultStaxUnmarshaller());
    }

    @Override
    public VerifyEmailIdentityResult verifyEmailIdentity(VerifyEmailIdentityRequest verifyEmailIdentityRequest) throws AmazonServiceException, AmazonClientException {
        Request<VerifyEmailIdentityRequest> request = new VerifyEmailIdentityRequestMarshaller().marshall(verifyEmailIdentityRequest);
        return this.invoke(request, new VerifyEmailIdentityResultStaxUnmarshaller());
    }

    @Override
    public GetIdentityNotificationAttributesResult getIdentityNotificationAttributes(GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetIdentityNotificationAttributesRequest> request = new GetIdentityNotificationAttributesRequestMarshaller().marshall(getIdentityNotificationAttributesRequest);
        return this.invoke(request, new GetIdentityNotificationAttributesResultStaxUnmarshaller());
    }

    @Override
    public VerifyDomainDkimResult verifyDomainDkim(VerifyDomainDkimRequest verifyDomainDkimRequest) throws AmazonServiceException, AmazonClientException {
        Request<VerifyDomainDkimRequest> request = new VerifyDomainDkimRequestMarshaller().marshall(verifyDomainDkimRequest);
        return this.invoke(request, new VerifyDomainDkimResultStaxUnmarshaller());
    }

    @Override
    public GetIdentityDkimAttributesResult getIdentityDkimAttributes(GetIdentityDkimAttributesRequest getIdentityDkimAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetIdentityDkimAttributesRequest> request = new GetIdentityDkimAttributesRequestMarshaller().marshall(getIdentityDkimAttributesRequest);
        return this.invoke(request, new GetIdentityDkimAttributesResultStaxUnmarshaller());
    }

    @Override
    public void verifyEmailAddress(VerifyEmailAddressRequest verifyEmailAddressRequest) throws AmazonServiceException, AmazonClientException {
        Request<VerifyEmailAddressRequest> request = new VerifyEmailAddressRequestMarshaller().marshall(verifyEmailAddressRequest);
        this.invoke(request, null);
    }

    @Override
    public SendRawEmailResult sendRawEmail(SendRawEmailRequest sendRawEmailRequest) throws AmazonServiceException, AmazonClientException {
        Request<SendRawEmailRequest> request = new SendRawEmailRequestMarshaller().marshall(sendRawEmailRequest);
        return this.invoke(request, new SendRawEmailResultStaxUnmarshaller());
    }

    @Override
    public ListIdentitiesResult listIdentities(ListIdentitiesRequest listIdentitiesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListIdentitiesRequest> request = new ListIdentitiesRequestMarshaller().marshall(listIdentitiesRequest);
        return this.invoke(request, new ListIdentitiesResultStaxUnmarshaller());
    }

    @Override
    public GetIdentityVerificationAttributesResult getIdentityVerificationAttributes(GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetIdentityVerificationAttributesRequest> request = new GetIdentityVerificationAttributesRequestMarshaller().marshall(getIdentityVerificationAttributesRequest);
        return this.invoke(request, new GetIdentityVerificationAttributesResultStaxUnmarshaller());
    }

    @Override
    public SetIdentityDkimEnabledResult setIdentityDkimEnabled(SetIdentityDkimEnabledRequest setIdentityDkimEnabledRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetIdentityDkimEnabledRequest> request = new SetIdentityDkimEnabledRequestMarshaller().marshall(setIdentityDkimEnabledRequest);
        return this.invoke(request, new SetIdentityDkimEnabledResultStaxUnmarshaller());
    }

    @Override
    public GetSendQuotaResult getSendQuota(GetSendQuotaRequest getSendQuotaRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetSendQuotaRequest> request = new GetSendQuotaRequestMarshaller().marshall(getSendQuotaRequest);
        return this.invoke(request, new GetSendQuotaResultStaxUnmarshaller());
    }

    @Override
    public SetIdentityFeedbackForwardingEnabledResult setIdentityFeedbackForwardingEnabled(SetIdentityFeedbackForwardingEnabledRequest setIdentityFeedbackForwardingEnabledRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetIdentityFeedbackForwardingEnabledRequest> request = new SetIdentityFeedbackForwardingEnabledRequestMarshaller().marshall(setIdentityFeedbackForwardingEnabledRequest);
        return this.invoke(request, new SetIdentityFeedbackForwardingEnabledResultStaxUnmarshaller());
    }

    @Override
    public VerifyDomainIdentityResult verifyDomainIdentity(VerifyDomainIdentityRequest verifyDomainIdentityRequest) throws AmazonServiceException, AmazonClientException {
        Request<VerifyDomainIdentityRequest> request = new VerifyDomainIdentityRequestMarshaller().marshall(verifyDomainIdentityRequest);
        return this.invoke(request, new VerifyDomainIdentityResultStaxUnmarshaller());
    }

    @Override
    public SendEmailResult sendEmail(SendEmailRequest sendEmailRequest) throws AmazonServiceException, AmazonClientException {
        Request<SendEmailRequest> request = new SendEmailRequestMarshaller().marshall(sendEmailRequest);
        return this.invoke(request, new SendEmailResultStaxUnmarshaller());
    }

    @Override
    public void deleteVerifiedEmailAddress(DeleteVerifiedEmailAddressRequest deleteVerifiedEmailAddressRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteVerifiedEmailAddressRequest> request = new DeleteVerifiedEmailAddressRequestMarshaller().marshall(deleteVerifiedEmailAddressRequest);
        this.invoke(request, null);
    }

    @Override
    public SetIdentityNotificationTopicResult setIdentityNotificationTopic(SetIdentityNotificationTopicRequest setIdentityNotificationTopicRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetIdentityNotificationTopicRequest> request = new SetIdentityNotificationTopicRequestMarshaller().marshall(setIdentityNotificationTopicRequest);
        return this.invoke(request, new SetIdentityNotificationTopicResultStaxUnmarshaller());
    }

    @Override
    public ListVerifiedEmailAddressesResult listVerifiedEmailAddresses() throws AmazonServiceException, AmazonClientException {
        return this.listVerifiedEmailAddresses(new ListVerifiedEmailAddressesRequest());
    }

    @Override
    public GetSendStatisticsResult getSendStatistics() throws AmazonServiceException, AmazonClientException {
        return this.getSendStatistics(new GetSendStatisticsRequest());
    }

    @Override
    public ListIdentitiesResult listIdentities() throws AmazonServiceException, AmazonClientException {
        return this.listIdentities(new ListIdentitiesRequest());
    }

    @Override
    public GetSendQuotaResult getSendQuota() throws AmazonServiceException, AmazonClientException {
        return this.getSendQuota(new GetSendQuotaRequest());
    }

    @Override
    protected String getServiceAbbreviation() {
        return "email";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

