/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.rds.model.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDBParameterGroupRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String dBParameterGroupName;
    private List<Parameter> parameters;

    public ModifyDBParameterGroupRequest() {
    }

    public ModifyDBParameterGroupRequest(String dBParameterGroupName, List<Parameter> parameters) {
        this.dBParameterGroupName = dBParameterGroupName;
        this.parameters = parameters;
    }

    public String getDBParameterGroupName() {
        return this.dBParameterGroupName;
    }

    public void setDBParameterGroupName(String dBParameterGroupName) {
        this.dBParameterGroupName = dBParameterGroupName;
    }

    public ModifyDBParameterGroupRequest withDBParameterGroupName(String dBParameterGroupName) {
        this.dBParameterGroupName = dBParameterGroupName;
        return this;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    public void setParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        ArrayList<Parameter> parametersCopy = new ArrayList<Parameter>(parameters.size());
        parametersCopy.addAll(parameters);
        this.parameters = parametersCopy;
    }

    public ModifyDBParameterGroupRequest withParameters(Parameter ... parameters) {
        if (this.getParameters() == null) {
            this.setParameters(new ArrayList<Parameter>(parameters.length));
        }
        for (Parameter value : parameters) {
            this.getParameters().add(value);
        }
        return this;
    }

    public ModifyDBParameterGroupRequest withParameters(Collection<Parameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            ArrayList<Parameter> parametersCopy = new ArrayList<Parameter>(parameters.size());
            parametersCopy.addAll(parameters);
            this.parameters = parametersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBParameterGroupName() != null) {
            sb.append("DBParameterGroupName: " + this.getDBParameterGroupName() + ",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBParameterGroupName() == null ? 0 : this.getDBParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : ((Object)this.getParameters()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDBParameterGroupRequest)) {
            return false;
        }
        ModifyDBParameterGroupRequest other = (ModifyDBParameterGroupRequest)obj;
        if (other.getDBParameterGroupName() == null ^ this.getDBParameterGroupName() == null) {
            return false;
        }
        if (other.getDBParameterGroupName() != null && !other.getDBParameterGroupName().equals(this.getDBParameterGroupName())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || ((Object)other.getParameters()).equals(this.getParameters());
    }
}

